/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.RoomSizeDictMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.RoomSizeDictPanel;
import com.gridnine.xtrip.client.fx.model.dict.RoomSizeDictPanelController;
import com.gridnine.xtrip.client.fx.model.dict.RoomSizeDictPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.RoomSizeDictReference;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class RoomSizeDictHandler
extends BaseDictHandler<RoomSizeDictPanel, RoomSizeDict, RoomSizeDictPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), RoomSizeDict.Property.codes.name(), Messages.Additional_Code, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), RoomSizeDict.Property.importedFromSabre.name(), Messages.From_Sabre_directory, (Renderer)StandardRenderers.BOOLEAN));
    }

    @Override
    protected void configureController(List<BiConsumer<RoomSizeDict, RoomSizeDictPanelVM>> toVM, List<BiConsumer<RoomSizeDictPanelVM, RoomSizeDict>> fromVM) {
        toVM.add((model, vm) -> {
            RoomSizeDictMainPanelVM main = vm.getMain();
            StringBuilder builder = new StringBuilder();
            Iterator iterator = model.getCodes().iterator();
            while (iterator.hasNext()) {
                builder.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                builder.append(',');
            }
            main.setId(model.getCode());
            main.setAdditionalCodes(builder.toString());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            RoomSizeDictMainPanelVM main = vm.getMain();
            model.setCode(StringUtils.trim((String)main.getId()));
            model.getCodes().clear();
            if (!TextUtil.isBlank((String)main.getAdditionalCodes())) {
                for (String str : main.getAdditionalCodes().trim().split(",")) {
                    if (TextUtil.isBlank((String)str)) continue;
                    model.getCodes().add(str.trim());
                }
            }
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<RoomSizeDict> getDictType() {
        return RoomSizeDict.class;
    }

    public DictionaryReference<RoomSizeDict> createReference(String code) {
        return new RoomSizeDictReference(code);
    }

    @Override
    protected RoomSizeDictPanelVM createVM() {
        return new RoomSizeDictPanelVM();
    }

    @Override
    protected ViewController<RoomSizeDictPanel, RoomSizeDictPanelVM> createController() {
        return new RoomSizeDictPanelController(false);
    }
}

