/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.ValidationMessageDictPanel;
import com.gridnine.xtrip.client.fx.model.dict.ValidationMessageDictPanelController;
import com.gridnine.xtrip.client.fx.model.dict.ValidationMessageDictPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ValidationMessageDict;
import com.gridnine.xtrip.common.model.dict.ValidationMessageDictReference;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesResourcesEnvironment;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.util.StringConverter;

public class ValidationMessageDictHandler
extends BaseDictHandler<ValidationMessageDictPanel, ValidationMessageDict, ValidationMessageDictPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ValidationMessageDict.Property.errorCode.name(), Messages.Code, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ValidationMessageDict.Property.category.name(), Messages.Category, new Renderer(){

            public RegistryItemType<Renderer> getType() {
                return null;
            }

            public String getId() {
                return null;
            }

            public String apply(Object t) {
                return t == null ? "" : t.toString();
            }
        }));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ValidationMessageDict.Property.errorCode.name(), Messages.Text, new Renderer(){

            public RegistryItemType<Renderer> getType() {
                return null;
            }

            public String getId() {
                return null;
            }

            public String apply(Object t) {
                if (t == null) {
                    return "";
                }
                for (Map.Entry entry : ValidationMessagesResourcesEnvironment.getFromEnvironment().getMessageTypes().entrySet()) {
                    if (!((ValidationMessageType)entry.getValue()).getErrorCode().equalsIgnoreCase(t.toString())) continue;
                    return L10nResourcesManager.getStr((String)((ValidationMessageType)entry.getValue()).getMessageKey(), (Object[])new Object[0]);
                }
                return "";
            }
        }));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ValidationMessageDict.Property.errorCode.name(), Messages.Default_type, new Renderer(){

            public RegistryItemType<Renderer> getType() {
                return null;
            }

            public String getId() {
                return null;
            }

            public String apply(Object t) {
                if (t == null) {
                    return "";
                }
                for (Map.Entry entry : ValidationMessagesResourcesEnvironment.getFromEnvironment().getMessageTypes().entrySet()) {
                    if (!((ValidationMessageType)entry.getValue()).getErrorCode().equalsIgnoreCase(t.toString())) continue;
                    return ((ValidationMessageType)entry.getValue()).getDefaultSeverity().toString();
                }
                return "";
            }
        }));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), ValidationMessageDict.Property.severity.name(), Messages.Current_type, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<ValidationMessageDict, ValidationMessageDictPanelVM>> toVM, List<BiConsumer<ValidationMessageDictPanelVM, ValidationMessageDict>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setValidationMessageCode(model.getErrorCode());
            vm.setValidationMessageType(model.getSeverity());
            vm.setValidationMessageDefaultType(model.getDefaultSeverity());
            vm.setValidationMessageCategory(model.getCategory());
        });
        fromVM.add((vm, model) -> {
            model.setErrorCode(vm.getValidationMessageCode());
            model.setSeverity(vm.getValidationMessageType());
            model.setDefaultSeverity(vm.getValidationMessageDefaultType());
            model.setCategory(vm.getValidationMessageCategory());
        });
    }

    public Class<ValidationMessageDict> getDictType() {
        return ValidationMessageDict.class;
    }

    public DictionaryReference<ValidationMessageDict> createReference(String code) {
        return new ValidationMessageDictReference(code);
    }

    @Override
    protected ValidationMessageDictPanelVM createVM() {
        return new ValidationMessageDictPanelVM();
    }

    @Override
    protected ViewController<ValidationMessageDictPanel, ValidationMessageDictPanelVM> createController() {
        ValidationMessageDictPanelController controller = new ValidationMessageDictPanelController(false);
        ComboBoxWidget messageCodeWidget = (ComboBoxWidget)controller.getView().getValidationMessageCodeCard().getContent();
        messageCodeWidget.setSortItems(false);
        messageCodeWidget.setItemsSupplier((Supplier)new Supplier<List<String>>(){
            private List<String> items;

            @Override
            public List<String> get() {
                if (this.items == null) {
                    this.items = ValidationMessagesResourcesEnvironment.getFromEnvironment().getMessageTypes().values().stream().map(ValidationMessageType::getErrorCode).sorted((lhs, rhs) -> {
                        int rNum;
                        int lNum;
                        String[] rArr;
                        String[] lArr = lhs.split("-");
                        if (lArr.length != (rArr = rhs.split("-")).length || lArr.length != 2) {
                            return lhs.compareTo((String)rhs);
                        }
                        int result = lArr[0].compareTo(rArr[0]);
                        if (result != 0) {
                            return result;
                        }
                        try {
                            lNum = Integer.parseInt(lArr[1]);
                        }
                        catch (NumberFormatException nfe) {
                            lNum = 0;
                        }
                        try {
                            rNum = Integer.parseInt(rArr[1]);
                        }
                        catch (NumberFormatException nfe) {
                            rNum = 0;
                        }
                        return Integer.compare(lNum, rNum);
                    }).collect(Collectors.toList());
                }
                return this.items;
            }
        });
        messageCodeWidget.setConverter((StringConverter)new StringConverter<String>(){

            public String toString(String object) {
                if (object == null) {
                    return null;
                }
                for (Map.Entry entry : ValidationMessagesResourcesEnvironment.getFromEnvironment().getMessageTypes().entrySet()) {
                    if (!((ValidationMessageType)entry.getValue()).getErrorCode().equalsIgnoreCase(object)) continue;
                    return object + " - " + L10nResourcesManager.getStr((String)((ValidationMessageType)entry.getValue()).getMessageKey(), (Object[])new Object[0]);
                }
                return object;
            }

            public String fromString(String string) {
                return null;
            }
        });
        messageCodeWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(messageCodeWidget.getConverter(), messageCodeWidget.getItemsSupplier(), messageCodeWidget.isSortItems()));
        messageCodeWidget.valueProperty().addListener((s, o, n) -> {
            ValidationMessageType type = ValidationMessagesResourcesEnvironment.getFromEnvironment().getMessageTypes().values().stream().filter(vmt -> TextUtil.isSame((String)vmt.getErrorCode(), (String)n, (boolean)true, (boolean)true)).findFirst().orElse(null);
            ((ComboBoxWidget)controller.getView().getValidationMessageCategoryCard().getContent()).setValue((Object)(type == null ? null : type.getCategory()));
            ((ComboBoxWidget)controller.getView().getValidationMessageDefaultTypeCard().getContent()).setValue((Object)(type == null ? null : type.getDefaultSeverity()));
        });
        return controller;
    }

    public String format(ValidationMessageDict dict) {
        return dict.getErrorCode();
    }
}

