/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.VisaTypePanel;
import com.gridnine.xtrip.client.fx.model.dict.VisaTypePanelController;
import com.gridnine.xtrip.client.fx.model.dict.VisaTypePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.visa.VisaType;
import com.gridnine.xtrip.common.model.dict.visa.VisaTypeReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class VisaTypeHandler
extends BaseDictHandler<VisaTypePanel, VisaType, VisaTypePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<VisaType, VisaTypePanelVM>> toVM, List<BiConsumer<VisaTypePanelVM, VisaType>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setCode(model.getCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<VisaType> getDictType() {
        return VisaType.class;
    }

    public DictionaryReference<VisaType> createReference(String code) {
        return new VisaTypeReference(code);
    }

    @Override
    protected VisaTypePanelVM createVM() {
        return new VisaTypePanelVM();
    }

    @Override
    protected ViewController<VisaTypePanel, VisaTypePanelVM> createController() {
        return new VisaTypePanelController(false);
    }
}

