/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.currencyinfo;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.model.dict.CurrencyInfoPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.currencyinfo.CurrencyHelper;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.currencyinfo.CurrencyInfoHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

class StandardCurrencyInfoHandlerConfigurator
implements CurrencyInfoHandlerConfigurator {
    StandardCurrencyInfoHandlerConfigurator() {
    }

    @Override
    public void configureListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    public void configureController(List<BiConsumer<CurrencyInfo, CurrencyInfoPanelVM>> toVM, List<BiConsumer<CurrencyInfoPanelVM, CurrencyInfo>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setCode(model.getCode());
            CurrencyHelper.toVM(model, vm.getMain());
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            CurrencyHelper.fromVM(model, vm.getMain());
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }
}

