/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.passengertype;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.PassengerTypeCategoryReferencePanelVM;
import com.gridnine.xtrip.client.fx.model.dict.PassengerTypePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.passengertype.PassengerTypeHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

class StandardPassengerTypeHandlerConfigurator
implements PassengerTypeHandlerConfigurator {
    StandardPassengerTypeHandlerConfigurator() {
    }

    @Override
    public void configureListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.createColumn(PassengerType.class, PassengerType.Property.categories.name(), Messages.Categories, (Renderer)StandardRenderers.DICT_CODE));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    public void configureController(List<BiConsumer<PassengerType, PassengerTypePanelVM>> toVM, List<BiConsumer<PassengerTypePanelVM, PassengerType>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setId(model.getCode());
            VMHelper.transfer(model.getCategories(), vm.getCategory(), ctg -> {
                PassengerTypeCategoryReferencePanelVM result = new PassengerTypeCategoryReferencePanelVM();
                result.setCategory(ctg);
                return result;
            });
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getId()));
            VMHelper.transfer(vm.getCategory(), model.getCategories(), ctgVM -> ctgVM.getCategory());
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }
}

