/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.EntityLockHandler;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityParameters;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class RootEntityActivityHandler
extends ActivityHandler<RootEntityPane<?, ?>, RootEntityParameters> {
    private static String ID = "root-entity-activity-handler";
    private final Consumer<EntityModificationEvent> modificationEventHandler = evt -> {
        List refs = evt.getModifications().stream().filter(mod -> mod.getType() == EntityModification.ModificationType.DELETE).map(mod -> mod.getReference()).collect(Collectors.toList());
        if (refs.isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> this.closeActivities(refs));
    };

    public static RootEntityActivityHandler get() {
        return (RootEntityActivityHandler)RootEntityActivityHandler.forId((String)ID);
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new RootEntityActivityHandler());
        }
    }

    public static void editNew(DataTransferPackage<?, ?> dtp) {
        RootEntityActivityHandler.editNew(dtp, null);
    }

    public static void editNew(DataTransferPackage<?, ?> dtp, Consumer<RootEntityPane<?, ?>> callback) {
        RootEntityHandler handler = RootEntityHandler.forEntityClass((Class)dtp.getContainer().getEntityType());
        if (handler == null || !handler.isAvaibleInConfiguration()) {
            StandardNotifications.EDITOR_NOT_SUPPORTED.show(dtp.getContainer().getEntityType().getName());
            return;
        }
        NavigationParameters parameters = new NavigationParameters();
        parameters.setParameters((Object)new RootEntityParameters(handler.getId(), dtp.getContainer().getUid(), EditingMode.CREATE));
        ActivityManager.get().navigate(RootEntityActivityHandler.buildToken(dtp.getContainer().toReference()), (ActivityHandler)RootEntityActivityHandler.get(), parameters, editor -> {
            editor.readData(dtp, null);
            if (callback != null) {
                callback.accept((RootEntityPane<?, ?>)editor);
            }
        });
    }

    public static String buildToken(EntityReference<?> ref) {
        RootEntityHandler handler = RootEntityHandler.forEntityClass((Class)ref.getType());
        return handler == null ? null : RootEntityActivityHandler.buildToken(handler.getId(), ref.getUid());
    }

    private static String buildToken(String handlerId, String containerUid) {
        return handlerId + '|' + containerUid;
    }

    private static <C extends RootEntityPane<?, ?>> void handleOpenCallback(final C editor, final Consumer<C> callback) {
        if (callback == null) {
            return;
        }
        if (editor.getData() != null) {
            callback.accept(editor);
            return;
        }
        if (editor.getMutex().isAcquired()) {
            editor.getMutex().acquiredProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    editor.getMutex().acquiredProperty().removeListener((ChangeListener)this);
                    callback.accept(editor);
                }
            });
            return;
        }
        Notifications.get().submitTask(() -> {
            editor.reloadData();
            FxUtil.submitToFxThread(() -> callback.accept(editor));
        }, editor.getMutex());
    }

    private RootEntityActivityHandler() {
        Environment.publish(RootEntityEditingService.class, (ref, forEditing, callback, bg) -> {
            if (ref.getType() == null) {
                Notifications.get().showFlashNotification(Messages.Incorrect_reference_to_the_document, null);
                return;
            }
            RootEntityHandler handler = RootEntityHandler.forEntityClass((Class)ref.getType());
            if (handler == null || !handler.isAvaibleInConfiguration()) {
                if (forEditing) {
                    StandardNotifications.EDITOR_NOT_SUPPORTED.show(ref.getType().getName());
                } else {
                    StandardNotifications.VIEWER_NOT_SUPPORTED.show(ref.getType().getName());
                }
                return;
            }
            NavigationParameters parameters = new NavigationParameters();
            parameters.setTitle(ref.getCaption());
            parameters.setParameters((Object)new RootEntityParameters(handler.getId(), ref.getUid(), forEditing ? EditingMode.EDIT : EditingMode.VIEW));
            ActivityManager.get().navigate(RootEntityActivityHandler.buildToken(handler.getId(), ref.getUid()), (ActivityHandler)RootEntityActivityHandler.get(), parameters, true, editorPane -> RootEntityActivityHandler.handleOpenCallback(editorPane, callback), bg);
        });
        EventBus.get().subscribe(EntityModificationEvent.TYPE, this.modificationEventHandler);
    }

    private void closeActivities(List<EntityReference<?>> refs) {
        for (EntityReference<?> ref : refs) {
            RootEntityHandler handler = RootEntityHandler.forEntityClass((Class)ref.getType());
            if (handler == null) continue;
            ActivityManager.get().remove(RootEntityActivityHandler.buildToken(handler.getId(), ref.getUid()), true);
        }
    }

    public String getId() {
        return ID;
    }

    protected boolean isHighlighted(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) {
        if (super.isHighlighted(state)) {
            return true;
        }
        RootEntityPane view = (RootEntityPane)this.getView(state);
        return view != null && view.getMode() != EditingMode.VIEW;
    }

    protected RootEntityPane<?, ?> createView(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) {
        RootEntityHandler entityHandler = RootEntityHandler.forId((String)((RootEntityParameters)state.getParameters()).getHandlerId());
        RootEntityPane result = new RootEntityPane(state.getMutex(), entityHandler, this.createLockHandler(entityHandler, state), ((RootEntityParameters)state.getParameters()).getEditingMode(), ((RootEntityParameters)state.getParameters()).getContainerUid());
        FxUtil.bind((Property)state.titleProperty(), (ObservableValue)result.titleProperty());
        FxUtil.bind((Property)state.descriptionProperty(), (ObservableValue)result.descriptionProperty());
        this.updateState(state, result);
        result.modeProperty().addListener((obj, oldValue, newValue) -> this.updateState(state, result));
        if (result.getMode() != EditingMode.CREATE) {
            Notifications.get().submitTask(() -> {
                result.reloadData();
                if (((RootEntityParameters)state.getParameters()).getEditingMode() == EditingMode.EDIT && result.getData() != null && result.getData().getContainer() != null) {
                    result.tryLock(result.getData().getContainer().getVersionInfo().getVersionNumber());
                }
            }, state.getMutex());
        }
        EventBus.get().subscribe(EntityModificationEvent.TYPE, result.getModificationEventHandler());
        return result;
    }

    private void updateState(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state, RootEntityPane<?, ?> editor) {
        if (editor.getMode() != ((RootEntityParameters)state.getParameters()).getEditingMode()) {
            ((RootEntityParameters)state.getParameters()).setEditingMode(editor.getMode());
            state.parametersChanged();
        }
        state.setStateful(editor.getMode() != EditingMode.CREATE);
    }

    private EntityLockHandler createLockHandler(RootEntityHandler<?, ?> entityHandler, final ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) {
        return new EntityLockHandler(){
            private final AtomicBoolean locked;
            {
                this.locked = new AtomicBoolean(state.isLocked());
            }

            public void tryLock(int version) throws Exception {
                ((RootEntityParameters)state.getParameters()).setVersion(version);
                RootEntityActivityHandler.this.tryLock(state);
                ((RootEntityParameters)state.getParameters()).setEditingMode(state.isLocked() ? EditingMode.EDIT : EditingMode.VIEW);
                this.locked.set(state.isLocked());
                if (!state.isLocked()) {
                    String message = state.getLockOwner() == null ? Messages.Cannot_edit_document : Messages.getCannot_edit_document_Blocked_by_user(state.getLockOwner());
                    Notifications.get().showFlashNotification(message, null);
                }
            }

            public void unLock() {
                try {
                    RootEntityActivityHandler.this.unLock(state, false);
                    FxUtil.waitForFxThread(() -> this.locked.set(state.isLocked()));
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }

            public boolean isLocked() {
                return this.locked.get();
            }
        };
    }

    protected void doUnlock(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) {
        super.doUnlock(state);
        ((RootEntityParameters)state.getParameters()).setEditingMode(state.isLocked() ? EditingMode.EDIT : EditingMode.VIEW);
    }

    protected boolean hasChanges(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) {
        RootEntityPane view = (RootEntityPane)this.getView(state);
        return view != null && view.isDataChanged();
    }

    protected void onClosed(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) {
        RootEntityPane view = (RootEntityPane)this.getView(state);
        if (view == null) {
            return;
        }
        EventBus.get().unsubscribe((Object)view.getModificationEventHandler());
    }

    protected void handleClosing(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state, Runnable callback) {
        RootEntityPane view = (RootEntityPane)this.getView(state);
        if (view == null) {
            callback.run();
        } else {
            view.handleClosing(callback);
        }
    }

    protected void saveChanges(ActivityState<RootEntityPane<?, ?>, RootEntityParameters> state) throws Exception {
        RootEntityPane view = (RootEntityPane)this.getView(state);
        if (view == null) {
            return;
        }
        view.saveData();
    }

    protected Serializer<RootEntityParameters> getSerializer() {
        return RootEntityParameters.SERIALIZER;
    }
}

