/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.async.ShipmentsBillingItemsUpdateTaskParameters;
import com.gridnine.xtrip.common.fx.async.ShipmentsBillingItemsUpdateTaskResult;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.Message;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ShipmentsHelper {
    public static void updateShipment(final EntityReference<Shipment> shipment) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.shipmentsUpdateProcess;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.ShipmentsUpdateAsyncTask";
            }

            protected Serializable getTaskParameters() {
                ShipmentsBillingItemsUpdateTaskParameters parameters = new ShipmentsBillingItemsUpdateTaskParameters();
                parameters.getShipments().clear();
                parameters.getShipments().addAll(Collections.singleton(shipment));
                return parameters;
            }

            protected void onCompleted(Object object, List<Message> messages) {
                ShipmentsBillingItemsUpdateTaskResult result = (ShipmentsBillingItemsUpdateTaskResult)object;
                if (result.getChangeData() != null) {
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                }
                for (int i = 0; i < result.getDocuments().size(); ++i) {
                    RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                }
            }
        });
    }
}

