/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.AddRuleForContractsActionConfigurator;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsDialog;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RulesCustomProperties;
import com.gridnine.xtrip.common.fx.rpc.RulesAddProperties;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.subsidized.SubsidizedContractFilteringCategories;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public class AddRuleForContractsAction
implements IndexListAction {
    public boolean isAvailable(IndexListPane<?, ?> context) {
        for (AddRuleForContractsActionConfigurator cfg : ClientRegistry.get().allOf(AddRuleForContractsActionConfigurator.TYPE).values()) {
            if (!cfg.isAvailable(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        RulesViewConfiguration config = new RulesViewConfiguration();
        config.setActionsSupplier(target -> {
            List result = RulesEnvironment.get().getActions(target).stream().filter(action -> {
                boolean flag = false;
                for (RuleFilteringCategory category : RulesEnvironment.get().getFilteringCategories()) {
                    if (!AddRuleForContractsAction.checkFilteringCategory(category) || !RulesEnvironment.get().getActions(category).contains(action) || !RulesEnvironment.get().getTargets(category).contains(target)) continue;
                    flag = true;
                }
                return flag;
            }).collect(Collectors.toList());
            return result;
        });
        config.setTargetsSupplier(() -> {
            boolean additionalTargetsNeeded = Prefetched.getData().isShowSabreSyncRuleTargets();
            HashSet<RuleTarget> targets = new HashSet<RuleTarget>();
            for (RuleFilteringCategory category : RulesEnvironment.get().getFilteringCategories()) {
                if (!AddRuleForContractsAction.checkFilteringCategory(category)) continue;
                for (RuleTarget target : RulesEnvironment.get().getTargets(category)) {
                    if (!target.isAvailableToCreate() || !additionalTargetsNeeded && Arrays.asList(SabreSynchronizationAdditionalTargets.values()).contains(target)) continue;
                    targets.add(target);
                }
            }
            return new ArrayList(targets);
        });
        config.getFilters().addAll(Arrays.asList(StandardFilters.values()));
        List<EntityReference<?>> listRef = context.getSelectedItems().stream().map(EntityIndex::getSource).collect(Collectors.toList());
        List<RuleTarget> targets = config.getTargetsSupplier().get();
        if (targets.size() == 1) {
            this.createRule(targets.get(0), config, source, listRef);
            return;
        }
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> targets);
        widget.setConverter((StringConverter)new StringConverter<RuleTarget>(){

            public String toString(RuleTarget object) {
                return object == null ? "" : object.getDisplayName();
            }

            public RuleTarget fromString(String string) {
                return null;
            }
        });
        widget.setNoNulls(true);
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(Messages.Choose_object_with_rule).setBody((Node)widget).setActionHandler(() -> {
            RuleTarget target = (RuleTarget)widget.getValue();
            if (target == null) {
                return;
            }
            this.createRule(target, config, source, listRef);
        }).setActionAvailability((BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).show((Region)source);
    }

    private static boolean checkFilteringCategory(RuleFilteringCategory object) {
        return ContractsFilteringCategories.contains((Object)object) || SubsidizedContractFilteringCategories.AVIA_SUBSIDIZED_CONTRACT == object;
    }

    private void createRule(RuleTarget target, RulesViewConfiguration configuration, Control source, List<EntityReference<?>> listRef) {
        RuleSettings src = new RuleSettings();
        src.setTarget(target);
        RuleSettingsDialog.edit((Node)source, configuration.getRuleParametersHandler(), configuration.getActionsSupplier(), src, () -> this.addRules(src, listRef), true, new RulesCustomProperties());
    }

    private void addRules(final RuleSettings src, final List<EntityReference<?>> listRef) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.Add_rule;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.contract.ContractRulesAddAsyncTask";
            }

            protected Serializable getTaskParameters() {
                return new RulesAddProperties(listRef, src, true);
            }

            protected void onCompleted(Object result, List<Message> log) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)listRef.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            }
        });
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.RULES;
    }

    public double getWeight() {
        return 60.0;
    }

    public String getId() {
        return "add-rule-tool";
    }
}

