/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class BookingFileApplyRulesListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.RULES;
    }

    public double getWeight() {
        return 33.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        IndexType idxType = MetaRegistryHelper.getIndexType((String)context.getIndexType().getName());
        return BookingFile.class.getName().equals(idxType.getEntityId());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        final List bfList = context.getSelectedItems().stream().map(index -> index.getSource()).collect(Collectors.toList());
        Dialog.confirm((Node)source, (String)Messages.Apply_rules_qus, () -> Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Apply_rules;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute() throws Exception {
                ArrayList<EntityReference> processed = new ArrayList<EntityReference>(bfList.size());
                try {
                    for (EntityReference bf : bfList) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        this.setProgress((byte)(processed.size() / bfList.size() * 100), bf.toString());
                        List messages = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).applyRules(ServiceInvocationContext.get(), Collections.singletonList(bf));
                        this.addMessages(messages);
                        processed.add(bf);
                    }
                }
                finally {
                    if (!processed.isEmpty()) {
                        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)BookingFileApplyRulesListAction.this, (Collection)processed.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                    }
                }
            }
        }));
    }

    public String getId() {
        return "booking-file-list-apply-rules";
    }
}

