/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportConflictAction;
import com.gridnine.xtrip.common.fx.model.support.BugReportProcessingParameters;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.support.BaseBugReport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.exchange.ImportType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;

public class BugReportProcessAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.PROCESS;
    }

    public double getWeight() {
        return 35.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return BaseBugReport.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> Arrays.asList(ImportConflictAction.BUG_REPORT_CLEANUP, ImportConflictAction.BUG_REPORT_REPLACE, ImportConflictAction.BUG_REPORT_DONT_REPLACE, ImportConflictAction.BUG_REPORT_APPEND));
        widget.setSortItems(false);
        widget.setNoNulls(true);
        widget.setValue((Object)ImportConflictAction.BUG_REPORT_DONT_REPLACE);
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(Messages.Bug_report_process_dialog_title).setBody((Node)widget).setActionCaption(Messages.Bug_report_process_dialog_action).setActionHandler(() -> {
            try {
                final BugReportProcessingParameters parameters = new BugReportProcessingParameters();
                parameters.setReport(dtp.getContainer().toReference());
                switch ((ImportConflictAction)((Object)((Object)widget.getValue()))) {
                    case BUG_REPORT_CLEANUP: {
                        parameters.setImportType(ImportType.CLEANUP);
                        break;
                    }
                    case BUG_REPORT_REPLACE: {
                        parameters.setImportType(ImportType.REPLACE);
                        break;
                    }
                    case BUG_REPORT_DONT_REPLACE: {
                        parameters.setImportType(ImportType.DONT_REPLACE);
                        break;
                    }
                    case BUG_REPORT_APPEND: {
                        parameters.setImportType(ImportType.APPEND);
                        break;
                    }
                }
                Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                    protected String getTitle() {
                        return Messages.Data_import;
                    }

                    protected void onCompleted(Object result, List<Message> log) {
                        log.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Data_import_complited, (Object[])new Object[0]));
                    }

                    protected Serializable getTaskParameters() {
                        return parameters;
                    }

                    protected String getTaskClassName() {
                        return "com.gridnine.xtrip.server.fx.async.entityactions.BugReportImportAsyncTask";
                    }
                });
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }).show((Region)source);
    }

    public String getId() {
        return "bugreport-process-data";
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return true;
    }
}

