/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CopyTaskPersistentParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class CorrectionCreateTask
extends ClientTask {
    private final List<BaseProduct> products;
    private final EntityReference<BookingFile> bookingFile;
    private final EntityReference<Organization> newClient;
    private final EntityReference<Organization> newPayer;

    public CorrectionCreateTask(List<BaseProduct> products, EntityReference<BookingFile> bookingFile, EntityReference<Organization> newClient, EntityReference<Organization> newPayer) {
        this.products = products;
        this.bookingFile = bookingFile;
        this.newClient = newClient;
        this.newPayer = newPayer;
    }

    protected String getTitle() {
        return Messages.Copying_of_the_ticket;
    }

    protected void execute() throws Exception {
        this.saveParameters();
        BookingFileService.BookingFileRPCResult bookingFileRPCResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).cloneProductsForCorrection(ServiceInvocationContext.get(), this.products.stream().map(BaseIdentity::getUid).collect(Collectors.toList()), this.bookingFile, this.newClient, this.newPayer);
        EntityReference sourceReference = bookingFileRPCResult.getResultObject();
        List resultMessageList = bookingFileRPCResult.getResultMessageList();
        if (bookingFileRPCResult.getResultUid() == null) {
            Message nullError = new Message();
            nullError.setType(MessageType.ERROR);
            L10nMessage l10n = new L10nMessage();
            l10n.setKey(Messages.Copy_Error);
            nullError.setMessage(l10n);
            nullError.setDetails(this.products.stream().map(BaseIdentity::getUid).collect(Collectors.joining(", ")));
            resultMessageList.add(nullError);
            this.addMessages(resultMessageList);
            return;
        }
        this.addMessages(resultMessageList);
        if (resultMessageList.stream().noneMatch(message -> message.getType() == MessageType.ERROR || message.getType() == MessageType.WARNING)) {
            RootEntityEditingService.get().open(sourceReference, true, rootEntityPane -> {
                BookingFileSpace tilesSpace = (BookingFileSpace)rootEntityPane.getEditor();
                CompactNavigatorWidget navigator = (CompactNavigatorWidget)((BookingFileProductsFullPanel)tilesSpace.getProductsTile().getFullNode()).getContent();
                Node node = UiUtil.findViewWithModelUid((Iterable)navigator.getViews(), (String)bookingFileRPCResult.getResultUid());
                if (node == null) {
                    Notifications.get().submitTask(() -> {
                        rootEntityPane.reloadData();
                        FxUtil.waitForFxThread(() -> {
                            Node node2 = UiUtil.findViewWithModelUid((Iterable)navigator.getViews(), (String)bookingFileRPCResult.getResultUid());
                            if (node2 != null) {
                                tilesSpace.expand(tilesSpace.getProductsTile());
                                navigator.selectView(node2);
                            }
                        });
                    }, Messages.Notifications_getting_data);
                } else {
                    tilesSpace.expand(tilesSpace.getProductsTile());
                    navigator.selectView(node);
                }
            });
        }
        this.refreshView(this.bookingFile);
    }

    private static File getPreferredDataFile() {
        return new File(Environment.getDataFolder(), "settings/preferred_data_correction_shipment_create_task.xml");
    }

    private void saveParameters() throws Exception {
        CopyTaskPersistentParameters persistentParameters = new CopyTaskPersistentParameters();
        File file = CorrectionCreateTask.getPreferredDataFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Files.write(file.toPath(), XSUtil.toByteArray((XSSerializable)persistentParameters), new OpenOption[0]);
    }

    private void refreshView(EntityReference<BookingFile> bookingFileEntityReference) {
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bookingFileEntityReference, EntityModification.ModificationType.CHANGE)));
    }
}

