/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.StandardFxService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import javafx.scene.control.Control;

public class CreateDocumentAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.CREATE_DOCUMENT;
    }

    public String getId() {
        return "entity-create-document";
    }

    public double getWeight() {
        return 40.0;
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.VIEW;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        Class entityClass = context.getEntityHandler().getEntityClass();
        return context.isLastVersion() && StockOrder.class.isAssignableFrom(entityClass);
    }

    public void execute(Control source, RootEntityPane<?, ?> ctx, boolean alt) {
        RootEntityPane.executeAction(ctx, () -> this.createDocument(ctx));
    }

    private void createDocument(RootEntityPane<?, ?> context) {
        if (!context.validate()) {
            return;
        }
        Notifications.get().submitTask(() -> {
            EntityContainer orderCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), StockOrder.class, context.getContainerUid());
            EntityContainer reportCtr = ((StandardFxService)RpcServiceManager.get().getService(StandardFxService.class)).getReportContainer(orderCtr, ServiceInvocationContext.get());
            if (reportCtr != null) {
                ReportDocument report = (ReportDocument)reportCtr.getEntity();
                if (!report.getMessages().isEmpty()) {
                    FxUtil.submitToFxThread(() -> ((TilesSpace)context.getEditor()).setMessages(new ArrayList(report.getMessages())));
                    return;
                }
            } else {
                Notifications.get().showFlashNotification(Messages.StockOrderNotGenerated, null);
                return;
            }
            EntityReference document = ((StandardFxService)RpcServiceManager.get().getService(StandardFxService.class)).getDocumentContent(orderCtr, reportCtr, ServiceInvocationContext.get());
            FxUtil.submitToFxThread(() -> {
                RootEntityEditingService.navigateTo((EntityReference)document);
                Notifications.get().showFlashNotification(Messages.StockOrderGenerated, null);
            });
        }, Messages.General_Background_process);
    }
}

