/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class DebitOrderDetachFromShipmentAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 35.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Shipment.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.CREATE && context.getMode() != EditingMode.VIEW && context.getData() != null && context.getData().getContainer() != null && !((Shipment)context.getData().getContainer().getEntity()).getPaymentDocuments().isEmpty();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityContainer shipmentContainer = context.getData().getContainer();
        EntityBoxWidget widget = new EntityBoxWidget(BasePaymentDocument.class, false);
        widget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(BasicPaymentDocumentIndex.class);
            result.getSortings().put(BasicPaymentDocumentIndex.Property.date.name(), SortOrder.ASC);
            result.getSearchCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", (Collection)((Shipment)shipmentContainer.getEntity()).getPaymentDocuments().stream().map(EntityReference::getUid).collect(Collectors.toList())));
            result.getPatternSearchFields().add(BasicPaymentDocumentIndex.Property.number.name());
            ListParametersHelper.setFilters(result, BasicPaymentDocumentIndex.Property.date.name(), BasicPaymentDocumentIndex.Property.agent.name(), BasicPaymentDocumentIndex.Property.payer.name(), BasicPaymentDocumentIndex.Property.number.name(), BasicPaymentDocumentIndex.Property.organization.name());
            ListParametersHelper.setColumns(result, BasicPaymentDocumentIndex.Property.date.name(), BasicPaymentDocumentIndex.Property.agent.name(), BasicPaymentDocumentIndex.Property.payer.name(), BasicPaymentDocumentIndex.Property.number.name(), BasicPaymentDocumentIndex.Property.organization.name(), BasicPaymentDocumentIndex.Property.totalAmount.name());
            return result;
        });
        if (((Shipment)shipmentContainer.getEntity()).getPaymentDocuments().size() == 1) {
            widget.setValue((EntityReference)CollectionUtil.head((Iterable)((Shipment)shipmentContainer.getEntity()).getPaymentDocuments()));
        }
        new Dialog().setTitle(Messages.Select_payment_document).setBody((Node)widget).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose, () -> Notifications.get().submitTask(() -> {
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put(IBusFinanceContextKeys.DEBIT_ORDER_REFERENCE.name(), widget.getValue());
            contextMap.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name(), ((Shipment)shipmentContainer.getEntity()).getFinanceDocuments());
            Set<String> returnKeys = Collections.singleton(IBusStandardContextKeys.CHANGED_DATA.name());
            Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "debit-orders:detach", contextMap, returnKeys);
            ChangeData data = (ChangeData)ibusResult.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (data != null) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)data.getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            }
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Debit_order_detached, (Object[])new Object[0])});
        }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading), (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).addButton(DialogButtonStyle.DECLINE).show((Node)source);
    }

    public String getId() {
        return "detach-from-invoice-from-shipment";
    }
}

