/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.actions.BaseDeliveryEntityAddListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.DeliverySelectionPanel;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DeliveryService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DeliveryFinanceDocumentsAddListAction
extends BaseDeliveryEntityAddListAction {
    public String getId() {
        return "delivery-finance-documents-add";
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.DELIVERY;
    }

    public double getWeight() {
        return 52.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return FinanceDocumentRecordIndex.class.equals((Object)context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    @Override
    public String getTaskTitle() {
        return Messages.deliveryFinanceDocumentsAdd;
    }

    @Override
    public DeliverySelectionPanel createPanel(IndexListPane<?, ?> context) {
        return new DeliverySelectionPanel(false, false, null);
    }

    @Override
    public NestedEntityReference<BookingFile, BaseProduct> execute(IndexListPane<?, ?> context, DeliverySelectionPanel.DeliverySelectionData data) throws Exception {
        List financeDocumentRefs = context.getSelectedItems().stream().map(item -> item.getSource()).collect(Collectors.toList());
        List financeDocuments = financeDocumentRefs.stream().map(financeDocumentRef -> {
            try {
                return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), financeDocumentRef);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).map(financeDocumentEntityContainer -> (FinanceDocument)financeDocumentEntityContainer.getEntity()).collect(Collectors.toList());
        if (financeDocuments.stream().anyMatch(financeDocument -> financeDocument.getDelivery() != null)) {
            ArrayList messages = new ArrayList();
            financeDocuments.stream().filter(financeDocument -> financeDocument.getDelivery() != null).forEach(financeDocument -> messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.deliveryForDocumentExists, (Object[])new Object[]{financeDocument.getNumber()})));
            Notifications.get().showMessages(messages);
        }
        if (financeDocuments.stream().anyMatch(financeDocument -> financeDocument.getDelivery() == null)) {
            NestedEntityReference product = ((DeliveryService)RpcServiceManager.get().getService(DeliveryService.class)).addFinanceDocumentsToDelivery(ServiceInvocationContext.get(), financeDocumentRefs, data.getBookingFile(), data.getReservation() != null ? data.getReservation().getUid() : null, data.getDelivery() != null ? data.getDelivery().getUid() : null);
            return product;
        }
        return null;
    }
}

