/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.standard.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import javafx.scene.control.Control;

public class EntityVersionsAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.VERSIONS;
    }

    public String getId() {
        return "entity-versions";
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return true;
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.CREATE;
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        if (context.getData() == null || context.getData().getContainer() == null || context.getMode() == EditingMode.CREATE) {
            return super.getDescription(context);
        }
        EntityContainer ctr = context.getData().getContainer();
        StringBuilder buf = new StringBuilder();
        VersionInfo vi = ctr.getVersionInfo();
        DateFormat dtf = LocaleManager.get().getCurrentLocaleData().getDateTimeFormat();
        buf.append(Messages.Version_Created);
        if (vi.getCreated() != null) {
            buf.append(' ').append(dtf.format(ctr.getCreated()));
        }
        buf.append(' ').append(ctr.getCreatedBy()).append('\n');
        buf.append(Messages.Version_Modified);
        if (vi.getModified() != null) {
            buf.append(' ').append(dtf.format(vi.getModified()));
        }
        buf.append(' ').append(vi.getModifiedBy()).append('\n');
        buf.append(Messages.Version_Current).append(vi.getVersionNumber() + 1).append('\n');
        if (!TextUtil.isBlank((String)vi.getDataSource())) {
            buf.append(Messages.Version_Data_Source).append(vi.getDataSource()).append('\n');
        }
        if (!TextUtil.isBlank((String)vi.getVersionNotes())) {
            buf.append(Messages.Version_Comment).append(vi.getVersionNotes()).append('\n');
        }
        buf.append(Messages.Version_Total_Versions).append(ctr.getVersionsCount());
        return buf.toString();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityEditorHelper.showVersionsDialog(context.getData().getContainer().toReference(), context.getFixedVersionNumber(), context, context.getMutex());
    }
}

