/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.FinanceCorrectionDocumentsParametersPane;
import com.gridnine.xtrip.common.fx.rpc.FinanceDocumentsService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCorrectionCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskResult;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinanceDocumentsCorrectionCreateListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(CommonProductIndex.class);

    public String getId() {
        return "finance-documents-correction-create-list";
    }

    public double getWeight() {
        return 100.3;
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List products = context.getSelectedItems().stream().map(item -> new NestedEntityReference(item.getSource(), item.getNavigationKey(), BaseProduct.class, null)).distinct().collect(Collectors.toList());
        Notifications.get().submitTask(() -> this.doAction(source, context, products), context.getMutex());
    }

    private void doAction(Control source, IndexListPane<?, ?> context, List<NestedEntityReference<BookingFile, BaseProduct>> products) {
        Notifications.get().submitTask(() -> {
            Date date = new Date();
            Map datas = ((FinanceDocumentsService)RpcServiceManager.get().getService(FinanceDocumentsService.class)).getCorrectionShipmentFinanceDocumentProductDatas(ServiceInvocationContext.get(), (Collection)products);
            final FinanceCorrectionDocumentsParametersPane.FinanceDocumentsParameters parameters = new FinanceCorrectionDocumentsParametersPane.FinanceDocumentsParameters();
            parameters.setDate(date);
            parameters.getProducts().clear();
            parameters.getProducts().putAll(datas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry2 -> new MiscUtil.Pair(entry2.getValue(), (Object)Boolean.TRUE), (o1, o2) -> o1, () -> new TreeMap(MiscUtil.comparator(item -> datas.values().stream().filter(value -> value.get(item) != null).map(value -> ((FinanceDocumentsHelper.FinanceDocumentProductData)value.get(item)).getProduct()).findFirst().orElse(null), (Comparator)FinanceDocumentsHelper.productComparator)))))));
            FxUtil.waitForFxThread(() -> {
                FinanceCorrectionDocumentsParametersPane pane = new FinanceCorrectionDocumentsParametersPane();
                pane.readData(parameters);
                new Dialog().setTitle(Messages.financeDocumentsCreate).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> {
                    pane.writeData(parameters);
                    Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                        protected String getTitle() {
                            return Messages.financeDocumentsCreateProcess;
                        }

                        protected String getTaskClassName() {
                            return "com.gridnine.xtrip.server.fx.async.entityactions.FinanceDocumentCorrectionCreateAsyncTask";
                        }

                        protected Serializable getTaskParameters() {
                            FinanceDocumentsCorrectionCreateTaskParameters taskParameters = new FinanceDocumentsCorrectionCreateTaskParameters();
                            taskParameters.setDate(parameters.getDate());
                            taskParameters.setUseDelegate(parameters.getUseDelegate());
                            taskParameters.setUseFacsimile(parameters.getUseFacsimile());
                            taskParameters.setShipment(parameters.getShipment());
                            taskParameters.getProducts().clear();
                            taskParameters.getProducts().addAll(parameters.getProducts().values().stream().flatMap(item -> item.entrySet().stream()).filter(entry -> (Boolean)((MiscUtil.Pair)entry.getValue()).getSecond()).map(Map.Entry::getKey).filter(Objects::nonNull).collect(Collectors.toList()));
                            return taskParameters;
                        }

                        protected void onCompleted(Object object, List<Message> messages) {
                            FinanceDocumentsCreateTaskResult result = (FinanceDocumentsCreateTaskResult)object;
                            if (result.getChangeData() != null) {
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                            }
                            for (int i = 0; i < result.getDocuments().size(); ++i) {
                                RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                            }
                        }
                    });
                }, (BooleanExpression)pane.validProperty()).setExpandToParent(true).show((Node)source);
            });
        }, context.getMutex());
    }
}

