/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinancePrepaymentDocumentAttachFromShipmentAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 36.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && Shipment.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.CREATE && context.getMode() != EditingMode.VIEW;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityContainer shipmentContainer = context.getData().getContainer();
        EntityBoxWidget widget = new EntityBoxWidget(FinanceDocument.class, false);
        widget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(FinanceDocumentRecordIndex.class);
            result.getSortings().put(FinanceDocumentRecordIndex.Property.date.name(), SortOrder.ASC);
            result.getSearchCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.documentType.name(), (Object)FinanceDocumentType.INVOICE_PREPAYMENT));
            if (((Shipment)shipmentContainer.getEntity()).getPayer() != null) {
                result.getSearchCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.payer.name(), (Object)((Shipment)shipmentContainer.getEntity()).getPayer()));
            }
            for (EntityReference prepayment : ((Shipment)shipmentContainer.getEntity()).getPrepaymentFinanceDocuments()) {
                result.getSearchCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)prepayment.getUid()));
            }
            result.getPatternSearchFields().add(FinanceDocumentRecordIndex.Property.number.name());
            ListParametersHelper.setFilters(result, FinanceDocumentRecordIndex.Property.date.name(), FinanceDocumentRecordIndex.Property.agent.name(), FinanceDocumentRecordIndex.Property.payer.name(), FinanceDocumentRecordIndex.Property.number.name(), FinanceDocumentRecordIndex.Property.customer.name());
            ListParametersHelper.setColumns(result, FinanceDocumentRecordIndex.Property.date.name(), FinanceDocumentRecordIndex.Property.agent.name(), FinanceDocumentRecordIndex.Property.payer.name(), FinanceDocumentRecordIndex.Property.number.name(), FinanceDocumentRecordIndex.Property.customer.name(), FinanceDocumentRecordIndex.Property.totalAmount.name());
            return result;
        });
        new Dialog().setTitle(Messages.Select_finance_document).setBody((Node)widget).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose, () -> Notifications.get().submitTask(() -> {
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_REFERENCE.name(), widget.getValue());
            contextMap.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), Collections.singletonList(shipmentContainer.toReference()));
            Set<String> returnKeys = Collections.singleton(IBusStandardContextKeys.CHANGED_DATA.name());
            Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "finance-documents:attach", contextMap, returnKeys);
            ChangeData data = (ChangeData)ibusResult.get(IBusStandardContextKeys.CHANGED_DATA.name());
            if (data != null) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)data.getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)data.getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
            }
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Finance_document_attached, (Object[])new Object[0])});
        }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading), (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).addButton(DialogButtonStyle.DECLINE).show((Node)source);
    }

    public String getId() {
        return "finance-prepayment-document-shipment-attach";
    }
}

