/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.ExportSettingsService;
import com.gridnine.xtrip.common.model.finance.export.v2.ShipmentXmlExportSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.File;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;
import org.apache.commons.io.FileUtils;

public class GenerateShipmentXsdAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 32.0;
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getData() != null && context.getData().getContainer() != null;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        Class entityClass = context.getEntityHandler().getEntityClass();
        return context.isLastVersion() && ShipmentXmlExportSettings.class.isAssignableFrom(entityClass);
    }

    public String getId() {
        return "shipment-xsd-generation";
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        Notifications.get().submitTask(() -> {
            String content = ((ExportSettingsService)RpcServiceManager.get().getService(ExportSettingsService.class)).generateXsdSchema(ServiceInvocationContext.get(), ((ShipmentXmlExportSettings)context.getData().getContainer().getEntity()).getRootExportSettings(), "com.gridnine.xtrip.common.model.export.finance.v2.ShipmentExport");
            FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
            fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
            fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Files_xml_xsd, new String[]{"*.xsd", "*.xml"})));
            FxUtil.runInFxThread(() -> new Dialog().setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Creating_xsd_schema).setBody((Node)fileChooserWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Create, () -> {
                if (fileChooserWidget.getFiles().isEmpty()) {
                    Dialog.info((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Path_is_noy_specified);
                    return;
                }
                try {
                    File exportFile = (File)fileChooserWidget.getFiles().get(0);
                    FileUtils.writeStringToFile((File)exportFile, (String)content, (String)"UTF-8");
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }).showGlobal());
        }, context.getMutex());
    }
}

