/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.Identity;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class OrganizationBalancesChangeListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 30.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return OrganizationBalanceIndex.class.equals((Object)context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List indices = context.getSelectedItems();
        BooleanValueWidget widget = new BooleanValueWidget(false, false);
        widget.setValue(true);
        GridCell cell = new GridCell(Messages.UnlimitedCredit, (Node)widget);
        GridContainer gridContainer = new GridContainer();
        gridContainer.getCells().add((Object)cell);
        new Dialog().setTitle(Messages.ChangeOrganizationBalances).setBody((Node)gridContainer).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, () -> Notifications.get().submitTask(() -> {
            List uids = indices.stream().map(Identity::getUid).collect(Collectors.toList());
            Collection changedOrganizations = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).setUnlimitedCreditLimit(ServiceInvocationContext.get(), uids, widget.getValue());
            if (!changedOrganizations.isEmpty()) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.OrganizationBalancesWereChanged, (Object[])new Object[0])});
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)changedOrganizations.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            } else {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.OrganizationBalancesForChangeNotFound, (Object[])new Object[0])});
            }
        }, context.getMutex())).show(context);
    }

    public String getId() {
        return "change-organization-balances";
    }
}

