/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.standard.entity.actions.BaseDeliveryEntityAddListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.DeliverySelectionPanel;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DeliveryService;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProductAddToDeliveryListAction
extends BaseDeliveryEntityAddListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Collections.singletonList(CommonProductIndex.class);
    private static final Collection<Class<?>> DISALLOWED_TYPES = Collections.singletonList(DeliveryIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.DELIVERY;
    }

    public double getWeight() {
        return 52.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        Class indexType = context.getIndexType();
        return !DISALLOWED_TYPES.contains(indexType) && ALLOWED_TYPES.contains(indexType);
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    @Override
    public String getTaskTitle() {
        return Messages.deliveryFinanceDocumentsAdd;
    }

    @Override
    public DeliverySelectionPanel createPanel(IndexListPane<?, ?> context) {
        List<EntityReference<BookingFile>> selectedBookingFileList = context.getSelectedItems().stream().map(item -> item.getSource()).distinct().collect(Collectors.toList());
        return new DeliverySelectionPanel(true, true, selectedBookingFileList);
    }

    @Override
    public NestedEntityReference<BookingFile, BaseProduct> execute(IndexListPane<?, ?> context, DeliverySelectionPanel.DeliverySelectionData data) throws Exception {
        Map<String, EntityReference> productMap = context.getSelectedItems().stream().collect(Collectors.toMap(EntityIndex::getNavigationKey, item -> item.getSource()));
        return ((DeliveryService)RpcServiceManager.get().getService(DeliveryService.class)).addProductToDelivery(ServiceInvocationContext.get(), productMap, data.getBookingFile(), data.getReservation() != null ? data.getReservation().getUid() : null, data.getDelivery() != null ? data.getDelivery().getUid() : null);
    }

    public String getId() {
        return "product-add-to-delivery";
    }
}

