/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductRefundCreditSlipDialog;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.scene.control.Control;

public class ProductRefundCreditSlipAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.PRODUCT_REFUND_CREDIT_SLIP;
    }

    public double getWeight() {
        return 44.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return BookingFile.class.isAssignableFrom(context.getEntityHandler().getEntityClass()) && context.isLastVersion();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        if (dtp == null || dtp.getContainer() == null) {
            return false;
        }
        List<BaseProduct> products = this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity());
        return !products.isEmpty() && context.getMode().equals((Object)EditingMode.EDIT);
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        HashMap<BaseProduct, EntityContainer<BookingFile>> productsMap = new HashMap<BaseProduct, EntityContainer<BookingFile>>();
        this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity()).forEach(product -> productsMap.put((BaseProduct)product, (EntityContainer<BookingFile>)dtp.getContainer()));
        ProductRefundCreditSlipDialog dialog = new ProductRefundCreditSlipDialog(source, productsMap);
        FxUtil.submitToFxThread(dialog::showDialog);
    }

    public String getId() {
        return "product-refund-credit-slip";
    }

    private List<BaseProduct> getSuitableProducts(BookingFile bookingFile) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        if (bookingFile == null) {
            return result;
        }
        BookingHelper.getProducts((BookingFile)bookingFile).forEach(product -> {
            ProductHandler productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (ProductStatus.REFUND == productHandler.getStatus(product) || ProductStatus.SELL == productHandler.getStatus(product) && ProductCategory.MCO == productHandler.getProductCategory(product) && MCOCategory.PENALTY == productHandler.getMCOCategory(product)) {
                result.add((BaseProduct)product);
            }
        });
        return result;
    }
}

