/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductUnvoidListTask;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductUnvoidListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(ProductIndex.class, DeliveryIndex.class, InsuranceAccidentIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class, AeroexpressTicketIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.UNVOID;
    }

    public double getWeight() {
        return 11.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Dialog.confirm((Node)source, (String)Messages.Cancel_the_cancellation_of_the_selected_products, () -> {
            List<EntityIndex> selectedItems = context.getSelectedItems().stream().collect(Collectors.toList());
            HashMap<String, EntityReference<BookingFile>> productMap = new HashMap<String, EntityReference<BookingFile>>();
            selectedItems.forEach(productIndex -> productMap.put(productIndex.getNavigationKey(), productIndex.getSource()));
            Notifications.get().enqueueAsyncTask(new ProductUnvoidListTask(productMap));
        });
    }

    public String getId() {
        return "product-unvoidInList";
    }
}

