/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.DebitSlipCard;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class RenderDebitSlipEntityAction
implements RootEntityAction {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.EDIT.getId(), ModelRestrictionEntityResources.ENTITY_DEBIT_SLIP.getId());

    public AclQuery getACLQuery(RootEntityPane<?, ?> context) {
        return ACL_QUERY;
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.RENDER_CREDIT_DEBIT;
    }

    public double getWeight() {
        return 55.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return DebitSlip.class.isAssignableFrom(context.getEntityHandler().getEntityClass()) && context.isLastVersion();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode().equals((Object)EditingMode.EDIT);
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> Dialog.confirm((Node)source, (String)Messages.Dialog_confirm_render_credit_slip, () -> {
            EntityContainer debitSlipEntityContainer = context.getData().getContainer();
            HashMap<String, EntityReference> contextMap = new HashMap<String, EntityReference>();
            contextMap.put(IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_REFERENCE.name(), debitSlipEntityContainer.toReference());
            Notifications.get().submitTask(() -> {
                Map tempMap = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "payment-documents:render", contextMap, Collections.singleton("messages"));
                contextMap.clear();
                contextMap.putAll(tempMap);
                FxUtil.waitForFxThread(() -> {
                    ArrayList messages = new ArrayList();
                    messages.addAll(((Map)contextMap.get("messages")).values());
                    Notifications.get().showMessages(messages);
                    Notifications.get().submitTask(() -> {
                        context.reloadData();
                        FxUtil.waitForFxThread(() -> ((DebitSlipCard)context.getEditor()).getEditorCard().setCollapsed(false));
                    }, Messages.Notifications_getting_data);
                });
            }, Messages.Notifications_getting_data);
        }));
    }

    public String getId() {
        return "render-debit-slip";
    }
}

