/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizePersonListTask;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class SabreProfilesPersonListSynchronizeAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.SABRE_SYNC;
    }

    public double getWeight() {
        return 32.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return Prefetched.getData().getSabreProfilesSettings().isSyncActive() && PersonIndex.class.equals((Object)context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        if (!context.getSelectedItems().isEmpty()) {
            List items = context.getSelectedItems();
            SabreProfilesSynchronizationUtil.showConfirmation(Messages.Travelers_synhronization_Sabre, Messages.Synchronize_selected_traveler_profiles_in_Saber_Profiles, () -> Notifications.get().enqueueAsyncTask((ClientTask)new SabreProfilesSynchronizePersonListTask(items.stream().map(EntityIndex::getSource).collect(Collectors.toList()))), null);
        } else {
            SabreProfilesSynchronizationUtil.showConfirmation(Messages.Travelers_synhronization_Sabre, Messages.Synchronize_all_traveler_profiles_in_Saber_Profiles, () -> Notifications.get().enqueueAsyncTask((ClientTask)new SabreProfilesSynchronizePersonListTask(context.buildQuery())), null);
        }
    }

    public String getId() {
        return "person-list-synch-sabre-profiles";
    }
}

