/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.create;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.create.CreateEntityActionConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.xml.XSHelper;
import javafx.scene.control.Control;

public class CreateEntityAction
implements IndexListAction {
    private String id;

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.ADD;
    }

    public String getId() {
        return this.id;
    }

    public double getWeight() {
        return -1.0;
    }

    public KeyBindingAction getKeyBindingAction() {
        return StandardKeyBindingActions.NEW;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        if (ett == null || ett.isAbstract()) {
            return false;
        }
        this.id = BookingFile.class.getName().equals(ett.getId()) ? "booking-create" : "entity-create";
        for (CreateEntityActionConfigurator cfg : ClientRegistry.get().allOf(CreateEntityActionConfigurator.TYPE).values()) {
            if (!cfg.isForbidden(ett.getId())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        try {
            String entityType = MetaRegistryHelper.getIndexType((String)context.getIndexType().getName()).getEntityId();
            if (BookingFile.class.getName().equals(entityType)) {
                ProductFXHandler<?, ?, ?, ?> handler = ProductFXHandler.forProductIndexClass(((IndexListPaneConfiguration)context.getConfiguration()).getIndexType());
                CreateBookingHelper.createBookingFile((bf, uiData, parameters) -> {
                    if (handler != null) {
                        handler.updateNewBookingFile(bf, uiData, parameters);
                    }
                }, handler != null && handler.isShowCreateDialog());
                return;
            }
            RootEntityHandler entityHandler = RootEntityHandler.forEntityClass((Class)XSHelper.getClass((String)entityType));
            if (entityHandler == null || !entityHandler.isAvaibleInConfiguration()) {
                StandardNotifications.EDITOR_NOT_SUPPORTED.show(null);
                return;
            }
            Object supplement = null;
            if (entityHandler.getSupplementClass() != null && entityHandler.getSupplementClass() != Void.class) {
                supplement = entityHandler.getSupplementClass().newInstance();
            }
            DataTransferPackage dtp = new DataTransferPackage(new EntityContainer(entityHandler.getEntityClass()), supplement);
            for (CreateEntityActionConfigurator cfg : ClientRegistry.get().allOf(CreateEntityActionConfigurator.TYPE).values()) {
                if (!cfg.getId().equals(entityType)) continue;
                cfg.fillEntity(dtp);
            }
            RootEntityActivityHandler.editNew(dtp);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), MetaRegistryHelper.getIndexType((String)((IndexListPaneConfiguration)context.getConfiguration()).getIndexType().getName()).getEntityId());
    }
}

