/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.delete;

import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import java.util.Collection;

public interface DeleteEntityActionHandler<E extends BaseEntity>
extends RegistryItem<DeleteEntityActionHandler<?>> {
    public static final RegistryItemType<DeleteEntityActionHandler<?>> TYPE = new RegistryItemType("DELETE-ENTITY-ACTION-HANDLER");

    public static <E extends BaseEntity> DeleteEntityActionHandler<E> forEntityClass(Class<E> entityClass) {
        String className = entityClass.getName();
        for (DeleteEntityActionHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getEntityClass().getName().equals(className)) continue;
            return handler;
        }
        return null;
    }

    public static <E extends BaseEntity> DeleteEntityActionHandler<E> forEntityClass(String entityClassName) {
        for (DeleteEntityActionHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getEntityClass().getName().equals(entityClassName)) continue;
            return handler;
        }
        return null;
    }

    default public RegistryItemType<DeleteEntityActionHandler<?>> getType() {
        return TYPE;
    }

    default public String getId() {
        return this.getEntityClass().getName();
    }

    public Class<E> getEntityClass();

    public Collection<EntityReference<?>> delete(Collection<EntityReference<?>> var1) throws Exception;

    public boolean isDeletable(EntityContainer<E> var1);
}

