/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.delete;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.delete.DeleteEntityActionHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import com.gridnine.xtrip.common.fx.rpc.DeleteEntitiesProperties;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Referenceable;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class DeleteEntityListAction
implements IndexListAction {
    private static final Collection<String> FORBIDDEN_CLASS_NAMES = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList(BookingFile.class.getName(), StockBlank.class.getName(), BillingTransaction.class.getName())));
    private static final Collection<String> ALLOWED_INDEX_NAMES = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList(BookingFileIndex.class.getName())));

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.DELETE;
    }

    public double getWeight() {
        return 3.5;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType entityType = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        IndexType indexType = MetaRegistryHelper.getIndexType((String)context.getIndexType().getName());
        return !FORBIDDEN_CLASS_NAMES.contains(entityType.getId()) || ALLOWED_INDEX_NAMES.contains(indexType.getId());
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        if (!alt) {
            List items = context.getSelectedItems().stream().map(idx -> idx instanceof Referenceable ? ((Referenceable)idx).getRef() : idx.getSource()).collect(Collectors.toList());
            Map references = items.stream().collect(Collectors.groupingBy(EntityReference::getType, Collectors.toSet()));
            String message = items.stream().limit(5L).map(EntityReference::getCaption).collect(Collectors.joining("\n"));
            if (items.size() > 5) {
                message = message + "\n...";
            }
            Dialog.confirm(context, (String)Messages.Delete_selected_docs, (String)message, (String)Messages.Delete, () -> {
                for (Map.Entry entry : references.entrySet()) {
                    DeleteEntityActionHandler handler = DeleteEntityActionHandler.forEntityClass((Class)entry.getKey());
                    if (handler != null) {
                        try {
                            handler.delete((Collection)entry.getValue());
                        }
                        catch (Exception ex) {
                            ErrorHandler.handle((Throwable)ex);
                        }
                        continue;
                    }
                    Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask((Collection)entry.getValue()));
                }
            }, null);
        } else {
            Dialog.confirm(context, (String)Messages.Delete_objects_of_list, null, (String)Messages.Delete, () -> this.deleteInternal(context.getIndexType(), context.buildQuery()), null);
        }
    }

    public String getId() {
        return "entities-delete";
    }

    private void deleteInternal(final Class<EntityIndex<BaseEntity>> entityIndexType, final SearchQuery query) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.Objects_deletion;
            }

            protected void onCompleted(Object result, List<Message> log) {
                ChangeData changeData = (ChangeData)result;
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)changeData.getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)changeData.getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
            }

            protected Serializable getTaskParameters() {
                DeleteEntitiesProperties properties = new DeleteEntitiesProperties();
                properties.setEntityIndexType(entityIndexType);
                properties.setQuery(query);
                properties.setUser(ServiceInvocationContext.get().getUser());
                return properties;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.DeleteEntitiesQueryAsyncTask";
            }
        });
    }
}

