/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.delete;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.delete.DeleteEntityActionHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.DeleteShipmentsResult;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.DeleteEntitiesParameters;
import com.gridnine.xtrip.common.model.system.Message;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ShipmentDeleteHandler
implements DeleteEntityActionHandler<Shipment> {
    @Override
    public Class<Shipment> getEntityClass() {
        return Shipment.class;
    }

    @Override
    public Collection<EntityReference<?>> delete(final Collection<EntityReference<?>> references) throws Exception {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439";
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.DeleteEntitiesCustomAsyncTask";
            }

            protected Serializable getTaskParameters() {
                DeleteEntitiesParameters taskParameters = new DeleteEntitiesParameters();
                taskParameters.getReferences().clear();
                taskParameters.getReferences().addAll(references);
                return taskParameters;
            }

            protected void onCompleted(Object object, List<Message> log) {
                DeleteShipmentsResult result = (DeleteShipmentsResult)object;
                if (result.getChangeData() != null) {
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                }
                for (int i = 0; i < result.getDocuments().size(); ++i) {
                    RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                }
            }
        });
        return Collections.emptyList();
    }

    @Override
    public boolean isDeletable(EntityContainer<Shipment> container) {
        return ((Shipment)container.getEntity()).getCorrectionShipments().isEmpty() && ((Shipment)container.getEntity()).getPaymentItems().isEmpty();
    }
}

