/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.erasure;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.ErasureRequestStatus;
import com.gridnine.xtrip.common.model.rpc.TaskService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import javafx.scene.control.Control;

public class StopErasureProcessAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 0.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && context.getEntityHandler().getEntityClass().equals(ErasureRequest.class);
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return ErasureRequestStatus.PROCESSING.equals((Object)((ErasureRequest)context.getData().getContainer().getEntity()).getStatus());
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        ErasureRequest request = (ErasureRequest)context.getData().getContainer().getEntity();
        if (!ErasureRequestStatus.PROCESSING.equals((Object)request.getStatus())) {
            return;
        }
        LongRunningTaskInfo info = (LongRunningTaskInfo)request.getActiveTask();
        Notifications.get().submitTask(() -> this.changeTaskState(info), context.getMutex());
    }

    private void changeTaskState(LongRunningTaskInfo info) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        TaskService taskService = (TaskService)RpcServiceManager.get().getService(TaskService.class);
        switch (info.getState()) {
            case RUNNING: {
                taskService.stopTask(sic, info.getUid());
                break;
            }
        }
        EventBus.get().publishAsync((Event)new AssetModificationEvent(new AssetModification[]{new AssetModification((BaseAsset)info, AssetModification.ModificationType.CHANGE)}));
    }

    public String getId() {
        return "stop-erasure-action";
    }
}

