/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.CSVExporter;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExcelExporter;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportClientTask;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.StandardXMLExportFXHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.export.ExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ExportEntityClientTaskHelper {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    private ExportEntityClientTaskHelper() {
    }

    private static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static <E extends BaseEntity, I extends EntityIndex<E>> void exportXML(File file, Class<I> indexType, SearchQuery searchQuery, List<I> es, List<XMLFilterHelper.XMLFilter> filters) {
        if (es.size() > 0) {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportSelectedXML(file, es, addMessages, filters)));
        } else {
            Notifications.get().showFlashNotification(L10n.replace((String)Messages.Max_Export_Size, (Object[])new Object[]{10000}), null);
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportALLXML(file, searchQuery, indexType, addMessages, filters)));
        }
    }

    static <E extends BaseEntity> void exportXML(File file, EntityReference<E> ent, List<XMLFilterHelper.XMLFilter> filters) {
        Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportEntityToXML(file, ent, addMessages, filters)));
    }

    static <E extends BaseEntity> void exportXML(File file, Date startDate, Date endDate, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, EntityReference<Organization> client, List<XMLFilterHelper.XMLFilter> filters) {
        Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportXMLWithParameters(file, startDate, endDate, agency, subagency, salesPoint, client, addMessages, filters)));
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportSelectedXML(File file, List<I> es, Consumer<Message> messages, List<XMLFilterHelper.XMLFilter> filters) throws Exception {
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        ExportEntityClientTaskHelper.checkInterruption();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        for (EntityIndex index : es) {
            entityList.add(((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(sic, index.getSource()).getEntity());
        }
        ExportEntityClientTaskHelper.checkInterruption();
        ExportEntityClientTaskHelper.exportEntitiesToXML(file, entityList, messages, filters);
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportALLXML(File file, SearchQuery query, Class<I> indexType, Consumer<Message> messages, List<XMLFilterHelper.XMLFilter> filters) throws Exception {
        List<EntityIndex> listIndex;
        int offset = 0;
        query.setLimit(1000);
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        ExportEntityClientTaskHelper.checkInterruption();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        do {
            listIndex = ExportEntityClientTaskHelper.search(sic, indexType, query, offset);
            query.setOffset(offset += 1000);
            ExportEntityClientTaskHelper.checkInterruption();
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.replace((String)Messages.Objects_are_Loaded, (Object[])new Object[]{listIndex.size()}), (Object[])new Object[0]));
            for (EntityIndex index : listIndex) {
                EntityContainer container = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(sic, index.getSource());
                if (container == null) continue;
                entityList.add(container.getEntity());
            }
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.replace((String)Messages.Loaded_Objects, (Object[])new Object[]{listIndex.size()}), (Object[])new Object[0]));
        } while (!listIndex.isEmpty() && offset <= 9000);
        ExportEntityClientTaskHelper.exportEntitiesToXML(file, entityList, messages, filters);
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportEntityToXML(File file, EntityReference<E> ref, Consumer<Message> messages, List<XMLFilterHelper.XMLFilter> filters) throws Exception {
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        ExportEntityClientTaskHelper.checkInterruption();
        EntityContainer ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ref);
        if (ctr != null) {
            BaseEntity ent = ctr.getEntity();
            entityList.add(ent);
            ExportEntityClientTaskHelper.exportEntitiesToXML(file, entityList, messages, filters);
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportEntitiesToXML(File file, List<E> entityList, Consumer<Message> messages, List<XMLFilterHelper.XMLFilter> filters) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Document document = ExportEntityClientTaskHelper.export(entityList, filters, messages);
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(out));
            FxUtil.saveToFile((File)file, (byte[])out.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    static <E extends BaseEntity, I extends EntityIndex<E>> void exportXLS(File file, Class<I> indexType, List<TableColumnSettings> columnSettings, SearchQuery searchQuery, List<I> es) {
        if (es.size() > 0) {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(messages -> ExportEntityClientTaskHelper.exportSelectedXLS(file, searchQuery, indexType, columnSettings, es, messages)));
        } else {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(messages -> ExportEntityClientTaskHelper.exportAllXLS(file, searchQuery, indexType, columnSettings, messages)));
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportSelectedXLS(File file, SearchQuery query, Class<I> indexType, List<TableColumnSettings> columnSettings, List<I> es, Consumer<Message> messages) throws Exception {
        try (HSSFWorkbook workBook = new HSSFWorkbook();
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            HSSFSheet sheet = workBook.createSheet();
            HSSFDataFormat format = workBook.createDataFormat();
            Map<String, HSSFCellStyle> cellStyles = ExcelExporter.collectStyles(workBook, columnSettings);
            ExcelExporter.createHeader(columnSettings, sheet, workBook);
            List<String> listUids = es.stream().map(Identity::getUid).collect(Collectors.toList());
            ExportEntityClientTaskHelper.checkInterruption();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_receiving_data, (Object[])new Object[0]));
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            List data = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(sic, indexType, ExportEntityClientTaskHelper.searchByUids(query, listUids, false));
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_received_data_block(data.size()), (Object[])new Object[0]));
            data.stream().filter(idx -> listUids.contains(idx.getUid())).forEach(idx -> ExcelExporter.createRow(columnSettings, arg_0 -> ((EntityIndex)idx).getValue(arg_0), sheet, cellStyles));
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            ExcelExporter.autosize(workBook);
            workBook.write((OutputStream)out);
            FxUtil.saveToFile((File)file, (byte[])out.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportAllXLS(File file, SearchQuery query, Class<I> indexType, List<TableColumnSettings> columnSettings, Consumer<Message> messages) throws Exception {
        try (HSSFWorkbook workBook = new HSSFWorkbook();
             ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            List<EntityIndex> listIndex;
            Map<String, HSSFCellStyle> cellStyles = ExcelExporter.collectStyles(workBook, columnSettings);
            HSSFSheet sheet = workBook.createSheet();
            ExcelExporter.createHeader(columnSettings, sheet, workBook);
            query.setLimit(1000);
            ExportEntityClientTaskHelper.checkInterruption();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_receiving_data, (Object[])new Object[0]));
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            HSSFSheet actualSheet = sheet;
            int offset = 0;
            do {
                listIndex = ExportEntityClientTaskHelper.search(sic, indexType, query, offset);
                messages.accept(MessageHelper.createMessage((String)Messages.getExport_received_data_block(listIndex.size()), (Object[])new Object[0]));
                ExportEntityClientTaskHelper.checkInterruption();
                for (EntityIndex idx : listIndex) {
                    ExcelExporter.createRow(columnSettings, arg_0 -> ((EntityIndex)idx).getValue(arg_0), actualSheet, cellStyles);
                    if (++offset % 65535 != 0) continue;
                    actualSheet = workBook.createSheet();
                    ExcelExporter.createHeader(columnSettings, actualSheet, workBook);
                }
            } while (!listIndex.isEmpty());
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            ExcelExporter.autosize(workBook);
            workBook.write((OutputStream)outStream);
            FxUtil.saveToFile((File)file, (byte[])outStream.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> List<I> search(ServiceInvocationContext sic, Class<I> indexType, SearchQuery indexQuery, int offset) throws Exception {
        indexQuery.setOffset(offset);
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(sic, indexType, indexQuery);
    }

    private static SearchQuery searchByUids(SearchQuery query, List<String> uids, boolean ignoreOrders) {
        SearchQuery queryUids = new SearchQuery();
        queryUids.getCriteria().getCriterions().add(SearchCriterion.in((String)"uid", (Object[])uids.toArray()));
        queryUids.getPreferredProperties().addAll(query.getPreferredProperties());
        if (!ignoreOrders) {
            queryUids.getCriteria().getOrders().putAll(query.getCriteria().getOrders());
        }
        return queryUids;
    }

    static <E extends BaseEntity, I extends EntityIndex<E>> void exportCSV(File file, Class<I> indexType, List<TableColumnSettings> columnSettings, SearchQuery searchQuery, List<I> es) {
        if (es.size() > 0) {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(messages -> ExportEntityClientTaskHelper.exportSelectedCSV(file, searchQuery, indexType, columnSettings, es, messages)));
        } else {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(messages -> ExportEntityClientTaskHelper.exportAllCSV(file, searchQuery, indexType, columnSettings, messages)));
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportSelectedCSV(File file, SearchQuery query, Class<I> indexType, List<TableColumnSettings> columnSettings, List<I> es, Consumer<Message> messages) throws Exception {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();
             PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8));){
            AtomicBoolean firstColumn = new AtomicBoolean(true);
            AtomicBoolean useCustomRecordDelimiter = new AtomicBoolean(false);
            CSVExporter.UserSettings userSettings = new CSVExporter.UserSettings();
            CSVExporter.createHeader(columnSettings, out, firstColumn, useCustomRecordDelimiter, userSettings);
            query.setLimit(1000);
            ExportEntityClientTaskHelper.checkInterruption();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_receiving_data, (Object[])new Object[0]));
            List listUids = es.stream().map(Identity::getUid).collect(Collectors.toList());
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)"uid", (Object[])listUids.toArray()));
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            List data = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(sic, indexType, query);
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_received_data_block(data.size()), (Object[])new Object[0]));
            data.stream().filter(idx -> listUids.contains(idx.getUid())).forEach(idx -> CSVExporter.createRow(columnSettings, idx, out, firstColumn, useCustomRecordDelimiter, userSettings));
            out.flush();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            FxUtil.saveToFile((File)file, (byte[])outStream.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportAllCSV(File file, SearchQuery query, Class<I> indexType, List<TableColumnSettings> columnSettings, Consumer<Message> messages) throws Exception {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();
             PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8));){
            List<I> listIndex;
            int offset = 0;
            AtomicBoolean firstColumn = new AtomicBoolean(true);
            AtomicBoolean useCustomRecordDelimiter = new AtomicBoolean(false);
            CSVExporter.UserSettings userSettings = new CSVExporter.UserSettings();
            CSVExporter.createHeader(columnSettings, out, firstColumn, useCustomRecordDelimiter, userSettings);
            query.setLimit(1000);
            ExportEntityClientTaskHelper.checkInterruption();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_receiving_data, (Object[])new Object[0]));
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            do {
                listIndex = ExportEntityClientTaskHelper.search(sic, indexType, query, offset);
                messages.accept(MessageHelper.createMessage((String)Messages.getExport_received_data_block(listIndex.size()), (Object[])new Object[0]));
                ExportEntityClientTaskHelper.checkInterruption();
                listIndex.forEach(idx -> CSVExporter.createRow(columnSettings, idx, out, firstColumn, useCustomRecordDelimiter, userSettings));
            } while (!listIndex.isEmpty() && (offset += 1000) < 64535);
            out.flush();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            FxUtil.saveToFile((File)file, (byte[])outStream.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    static <E extends BaseEntity, I extends EntityIndex<E>> void exportZIP(File file, List<?> list, Class<I> entityIndexType, SearchQuery query) {
        if (list.size() > 0) {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportSelectedZIP(file, list.stream().filter(Objects::nonNull).map(EntityIndex::getSource).collect(Collectors.toList()), addMessages)));
        } else {
            Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportAllZIP(file, entityIndexType, query, addMessages)));
        }
    }

    static void exportZIP(File file, EntityReference<?> ref) {
        Notifications.get().enqueueAsyncTask((ClientTask)new ExportClientTask(addMessages -> ExportEntityClientTaskHelper.exportSelectedZIP(file, Collections.singletonList(ref), addMessages)));
    }

    private static <E extends BaseEntity> void exportSelectedZIP(File file, List<EntityReference<E>> list, Consumer<Message> messages) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ZipOutputStream outputStream = new ZipOutputStream(out);){
            outputStream.setComment("xTrip data archive");
            Document document = DocumentBuilderHelper.newDocument();
            document.appendChild(document.createElement("objects"));
            document.getDocumentElement().setAttribute("totalCount", Integer.toString(list.size()));
            ExportEntityClientTaskHelper.checkInterruption();
            String entityClassName = "";
            ServiceInvocationContext ctx = ServiceInvocationContext.get();
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.replace((String)Messages.Objects_are_Loaded, (Object[])new Object[]{list.size()}), (Object[])new Object[0]));
            for (EntityReference<E> ref : list) {
                EntityContainer container = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ctx, ref);
                ExportEntityClientTaskHelper.checkInterruption();
                Element elm = document.createElement("object");
                document.getDocumentElement().appendChild(elm);
                elm.setAttribute("class", EntityContainer.class.getName());
                entityClassName = container.getEntityType().getName();
                ExportEntityClientTaskHelper.checkInterruption();
                container.toXML(elm);
            }
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.replace((String)Messages.Loaded_Objects, (Object[])new Object[]{list.size()}), (Object[])new Object[0]));
            String name = entityClassName != null ? entityClassName + "_" : "entity_";
            name = name + dateFormat.format(new Date());
            outputStream.putNextEntry(new ZipEntry(String.format("%s.xml", name)));
            StreamResult result = new StreamResult(outputStream);
            ExportEntityClientTaskHelper.checkInterruption();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), result);
            outputStream.flush();
            outputStream.finish();
            outputStream.closeEntry();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            FxUtil.saveToFile((File)file, (byte[])out.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void exportAllZIP(File file, Class<I> entityIndexType, SearchQuery query, Consumer<Message> messages) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ZipOutputStream outputStream = new ZipOutputStream(out);){
            List<EntityIndex> listIndex;
            outputStream.setComment("xTrip data archive");
            outputStream.putNextEntry(new ZipEntry(String.format("%s.xml", entityIndexType.getSimpleName().toLowerCase() + '_' + dateFormat.format(new Date()))));
            int offset = 0;
            int entityCount = 0;
            query.setLimit(1000);
            Document document = DocumentBuilderHelper.newDocument();
            document.appendChild(document.createElement("objects"));
            ExportEntityClientTaskHelper.checkInterruption();
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            do {
                listIndex = ExportEntityClientTaskHelper.search(sic, entityIndexType, query, offset);
                query.setOffset(offset += 1000);
                messages.accept(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.replace((String)Messages.Objects_are_Loaded, (Object[])new Object[]{listIndex.size()}), (Object[])new Object[0]));
                ExportEntityClientTaskHelper.checkInterruption();
                for (EntityIndex index : listIndex) {
                    ExportEntityClientTaskHelper.checkInterruption();
                    EntityContainer container = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(sic, index.getSource());
                    if (container == null) continue;
                    Element elm = document.createElement("object");
                    document.getDocumentElement().appendChild(elm);
                    elm.setAttribute("class", EntityContainer.class.getName());
                    ExportEntityClientTaskHelper.checkInterruption();
                    container.toXML(elm);
                    ++entityCount;
                }
                messages.accept(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.replace((String)Messages.Loaded_Objects, (Object[])new Object[]{listIndex.size()}), (Object[])new Object[0]));
            } while (!listIndex.isEmpty());
            document.getDocumentElement().setAttribute("totalCount", Integer.toString(entityCount));
            StreamResult result = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), result);
            outputStream.flush();
            outputStream.finish();
            outputStream.closeEntry();
            messages.accept(MessageHelper.createMessage((String)Messages.Export_saving_data, (Object[])new Object[0]));
            FxUtil.saveToFile((File)file, (byte[])out.toByteArray());
            messages.accept(MessageHelper.createMessage((String)Messages.getExport_done(file), (Object[])new Object[0]));
        }
    }

    private static <T extends BaseEntity> Document export(List<T> entities, List<XMLFilterHelper.XMLFilter> filters, Consumer<Message> messageConsumer) throws Exception {
        final ServiceInvocationContext sic = ServiceInvocationContext.get();
        ExportHelper.ObjectResolver fxResolver = new ExportHelper.ObjectResolver(){
            private final Map<DictionaryReference<?>, BaseDictionary> dictCache = new HashMap();
            private final Map<EntityReference<?>, BaseEntity> entityCache = new HashMap();

            public <E extends BaseEntity> E resolve(EntityReference<E> ref) throws Exception {
                if (ref == null) {
                    return null;
                }
                if (this.entityCache.containsKey(ref)) {
                    return (E)this.entityCache.get(ref);
                }
                EntityContainer container = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(sic, ref);
                BaseEntity entity = container == null ? null : container.getEntity();
                this.entityCache.put(ref, entity);
                return (E)entity;
            }

            public <D extends BaseDictionary> D resolve(DictionaryReference<D> ref) throws Exception {
                if (ref == null) {
                    return null;
                }
                if (this.dictCache.containsKey(ref)) {
                    return (D)this.dictCache.get(ref);
                }
                BaseDictionary dict = ((DictService)RpcServiceManager.get().getService(DictService.class)).load(sic, ref);
                this.dictCache.put(ref, dict);
                return (D)dict;
            }
        };
        ArrayList messages = new ArrayList();
        Document document = XMLExportHelper.export(entities, filters, (ExportHelper.ObjectResolver)fxResolver, messages);
        messages.forEach(messageConsumer);
        StandardXMLExportFXHandler handler = new StandardXMLExportFXHandler();
        handler.updateDocument(entities, document);
        return document;
    }

    public static void exportXMLWithParameters(File file, Date startDate, Date endDate, EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<SalesPoint> salesPoint, EntityReference<Organization> client, Consumer<Message> messages, List<XMLFilterHelper.XMLFilter> filters) throws Exception {
        ExportEntityClientTaskHelper.checkInterruption();
        SearchQuery productQuery = new SearchQuery();
        SearchQuery fopQuery = new SearchQuery();
        HashSet<BaseEntity> bookingFiles = new HashSet<BaseEntity>();
        fopQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        if (startDate != null) {
            productQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)startDate));
            fopQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductFopIndex.Property.fopDate.name(), (Object)startDate));
        }
        if (endDate != null) {
            productQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)endDate)));
            fopQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductFopIndex.Property.fopDate.name(), (Object)MiscUtil.setDayEndTime((Date)endDate)));
        }
        if (agency != null) {
            productQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), agency));
            fopQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.agency.name(), agency));
        }
        if (subagency != null) {
            productQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), subagency));
            fopQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.subagency.name(), subagency));
        }
        if (salesPoint != null) {
            productQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.salesPoint.name(), salesPoint));
            fopQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.salesPoint.name(), salesPoint));
        }
        if (client != null) {
            productQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), client));
            fopQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.client.name(), client));
        }
        ExportEntityClientTaskHelper.checkInterruption();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        List indexList = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(sic, CommonProductIndex.class, productQuery);
        for (CommonProductIndex index : indexList) {
            EntityContainer container = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(sic, index.getSource());
            if (container == null) continue;
            bookingFiles.add(container.getEntity());
        }
        ExportEntityClientTaskHelper.checkInterruption();
        List fopindexList = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(sic, CommonProductFopIndex.class, fopQuery);
        for (CommonProductFopIndex index : fopindexList) {
            EntityContainer container = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(sic, index.getSource());
            if (container == null) continue;
            bookingFiles.add(container.getEntity());
        }
        ExportEntityClientTaskHelper.checkInterruption();
        ExportEntityClientTaskHelper.exportEntitiesToXML(file, new ArrayList(bookingFiles), messages, filters);
    }
}

