/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers;

import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportImportHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ExportHelperService;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Agency;
import com.gridnine.xtrip.common.model.profile.Agent;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Vendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportZipTask
extends ClientTask {
    private static final int ENTITY_BATCH_SIZE = 25;
    private static final int DICT_BATCH_SIZE = 500;
    private final File file;
    private final List<ItemExportSettings> exportSettings;

    private static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public ExportZipTask(File file, List<ItemExportSettings> exportSettingsList) {
        this.file = file;
        this.exportSettings = exportSettingsList;
    }

    protected void execute() throws Exception {
        try (ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));){
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_Data_Collection_Begun, (Object[])new Object[0])});
            outputStream.setComment("MOM data archive");
            this.export(outputStream);
            outputStream.flush();
            outputStream.finish();
            outputStream.closeEntry();
        }
        catch (IOException ioe) {
            ErrorHandler.handle((Throwable)FxUtil.wrapIOException((IOException)ioe));
        }
        this.setProgress((byte)100, Messages.Export_complited);
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Export_complited, (Object[])new Object[0])});
    }

    private void export(ZipOutputStream strm) throws Exception {
        int n = 0;
        for (ItemExportSettings item : this.exportSettings) {
            ExportZipTask.checkInterruption();
            switch (item.getItemType()) {
                case ENTITY: {
                    this.exportEntity(item, strm);
                    break;
                }
                case DICTIONARY: {
                    this.exportDictionary(item, strm);
                    break;
                }
                case ASSET: {
                    this.exportAsset(item, strm);
                    break;
                }
                default: {
                    throw new Exception("not supported item type " + item.getItemType().name());
                }
            }
            this.setProgress((byte)Math.round(100.0 * (double)(++n) / (double)this.exportSettings.size()), "Exported: " + item.getObjectId());
        }
    }

    private void exportEntity(ItemExportSettings item, ZipOutputStream strm) throws Exception {
        ArrayList<String> uids;
        EntityType entityType = (EntityType)MetaRegistry.get().getEntities().get(item.getObjectId());
        String name = entityType == null ? item.getObjectId() : entityType.getDisplayName();
        Class cls = XSHelper.getClass((String)item.getObjectId());
        if (item.getQueryData() != null && item.getQueryData().getQuery() != null && ExportImportHelper.getDeprecated().contains(entityType.getId())) {
            if (entityType.getId().equals(Agent.class.getName())) {
                cls = XSHelper.getClass((String)Person.class.getName());
            } else if (entityType.getId().equals(Agency.class.getName())) {
                cls = XSHelper.getClass((String)Organization.class.getName());
            } else if (entityType.getId().equals(Vendor.class.getName())) {
                cls = XSHelper.getClass((String)Organization.class.getName());
            }
        }
        try {
            switch (item.getExportType()) {
                case ALL: {
                    uids = new ArrayList(((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getEntityUids(ServiceInvocationContext.get(), cls));
                    break;
                }
                case SELECTED: {
                    uids = new ArrayList<String>();
                    for (Object obj : item.getSelectedItems()) {
                        uids.add(((EntityReference)obj).getUid());
                    }
                    break;
                }
                default: {
                    SearchQuery query = item.getQueryData().getQuery();
                    query.getPreferredProperties().add("containerUid");
                    uids = new ArrayList();
                    for (EntityIndex index : ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), XSHelper.getClass((String)item.getQueryData().getIndexClassName()), query)) {
                        if (uids.contains(index.getSource().getUid())) continue;
                        uids.add(index.getSource().getUid());
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_Warning_Failed_To_Get_List, (Throwable)e, (Object[])new Object[0])});
            return;
        }
        int size = uids.size();
        if (size == 0) {
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_Warning_No_Object_Of_Type_N, (Object[])new Object[]{name})});
            return;
        }
        ArrayList<EntityContainer> bundle = new ArrayList<EntityContainer>(25);
        int bundleIndex = 0;
        for (int n = 0; n < size; ++n) {
            block21: {
                ExportZipTask.checkInterruption();
                try {
                    EntityContainer ctr;
                    String etcUid = (String)uids.get(n);
                    Integer versionNumber = null;
                    String versionDelimiter = "|version=";
                    if (etcUid.contains(versionDelimiter)) {
                        int idx = etcUid.indexOf(versionDelimiter);
                        versionNumber = Integer.valueOf(etcUid.substring(idx + versionDelimiter.length()));
                        etcUid = etcUid.substring(0, idx);
                    }
                    if ((ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), cls, etcUid, versionNumber, null).getContainer()) == null) break block21;
                    bundle.add(ctr);
                }
                catch (Throwable e) {
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_Warning_While_Exporting, (Throwable)e, (Object[])new Object[0])});
                    continue;
                }
            }
            if (n == 0 || n % 25 != 0) continue;
            this.exportObjects(bundle, strm, item.getObjectId(), bundleIndex, size);
            bundle.clear();
            ++bundleIndex;
        }
        if (!bundle.isEmpty()) {
            this.exportObjects(bundle, strm, item.getObjectId(), bundleIndex, size);
            bundle.clear();
        }
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_Search_For_Oobjects_Of_Type_N_Completed, (Object[])new Object[]{name})});
    }

    private void exportAsset(ItemExportSettings item, ZipOutputStream strm) throws Exception {
        int bundleIndex = 0;
        List assets = ((ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class)).getAssets(ServiceInvocationContext.get(), item);
        String name = item.getObjectId().substring(item.getObjectId().lastIndexOf(".") + 1);
        int size = assets.size();
        if (size == 0) {
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_Warning_No_Object_Of_Type_N, (Object[])new Object[]{name})});
            return;
        }
        this.exportObjects(assets, strm, item.getObjectId(), bundleIndex, size);
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_Search_For_Oobjects_Of_Type_N_Completed, (Object[])new Object[]{name})});
    }

    private void exportDictionary(ItemExportSettings item, ZipOutputStream strm) throws Exception {
        Class dictClass = XSHelper.getClass((String)item.getObjectId());
        DictionaryType dictionaryType = (DictionaryType)MetaRegistry.get().getDictionaries().get(dictClass.getName());
        String name = dictionaryType == null ? item.getObjectId() : dictionaryType.getDisplayName();
        ExportHelperService service = (ExportHelperService)RpcServiceManager.get().getService(ExportHelperService.class);
        List<String> codes = new ArrayList();
        switch (item.getExportType()) {
            case ALL: {
                codes = service.getDictionaryCodes(ServiceInvocationContext.get(), dictClass);
                break;
            }
            default: {
                for (Object obj : item.getSelectedItems()) {
                    codes.add(((DictionaryReference)obj).getCode());
                }
            }
        }
        int size = codes.size();
        if (size == 0) {
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_Warning_No_Element_Of_Directory_Of_Type_N, (Object[])new Object[]{name})});
            return;
        }
        ArrayList bundle = new ArrayList(500);
        int bundleIndex = 0;
        for (int n = 0; n < size; ++n) {
            bundle.add(codes.get(n));
            if (n == 0 || n % 500 != 0) continue;
            ExportZipTask.checkInterruption();
            List dicts = service.getDictionaries(ServiceInvocationContext.get(), dictClass, bundle);
            this.exportObjects(dicts, strm, item.getObjectId(), bundleIndex, size);
            bundle.clear();
            ++bundleIndex;
        }
        if (!bundle.isEmpty()) {
            ExportZipTask.checkInterruption();
            List dicts = service.getDictionaries(ServiceInvocationContext.get(), dictClass, bundle);
            this.exportObjects(dicts, strm, item.getObjectId(), bundleIndex, size);
            bundle.clear();
        }
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Notification_Search_For_Data_From_Directory_Completed, (Object[])new Object[]{name})});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportObjects(List<? extends XSerializable> bundle, ZipOutputStream strm, String objectId, int bundleIndex, int totalCount) throws InterruptedException {
        ExportZipTask.checkInterruption();
        try {
            Document result = DocumentBuilderHelper.newDocument();
            result.appendChild(result.createElement("objects"));
            Element rootElm = result.getDocumentElement();
            rootElm.setAttribute("totalCount", Integer.toString(totalCount));
            for (XSerializable xSerializable : bundle) {
                XHelper.writeObject((Element)rootElm, (String)"object", (Object)xSerializable);
            }
            String fileName = String.format("%s%08d.xml", objectId, bundleIndex);
            strm.putNextEntry(new ZipEntry(fileName));
            try {
                XUtil.newTransformer().transform(new DOMSource(result), new StreamResult(strm));
            }
            finally {
                strm.closeEntry();
            }
            strm.flush();
        }
        catch (Throwable e) {
            try {
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Notification_Warning_Failed_To_Export_Object, (Object[])new Object[]{bundle.toString()})});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String getTitle() {
        return Messages.Export_Data;
    }
}

