/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.BookingFileFiscalPayParamDialog;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class BookingFileFiscalListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(CommonProductIndex.class, AeroexpressTicketIndex.class, UniversalProductIndex.class, InsuranceAccidentIndex.class, DeliveryIndex.class, MainHotelProductIndex.class, InsuranceTouristicIndex.class, VisaProductIndex.class, AgencyMemoProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, MCOFeesIndex.class, ProductIndex.class, BookingFileIndex.class);

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.BOOKING_FILE_FISCAL;
    }

    public double getWeight() {
        return 75.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return ClientSettings.get().isEnabledRemoteFiscalServiceProvider() && !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Class indexType = context.getIndexType();
        try {
            if (!ALLOWED_TYPES.contains(indexType)) {
                throw Xeption.forDeveloper((String)"Product isn't supported: {0}", (Object[])new Object[]{indexType});
            }
            List items = context.getSelectedItems();
            Set bookingFiles = items.stream().map(EntityIndex::getSource).collect(Collectors.toSet());
            List selectedProductUids = items.stream().map(EntityIndex::getNavigationKey).filter(Objects::nonNull).collect(Collectors.toList());
            BookingFileFiscalPayParamDialog dialog = new BookingFileFiscalPayParamDialog(source);
            dialog.showDialog(bookingFiles, selectedProductUids);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public String getId() {
        return "booking-file-fiscal-list-action";
    }
}

