/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.personal.data;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.PersonalDataService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Optional;
import javafx.scene.control.Control;

public class PersonalDataPersonRequestRestoreAction
implements RootEntityAction {
    public String getId() {
        return "personal-data-person-request-restore";
    }

    public double getWeight() {
        return 200.0;
    }

    public String getName(RootEntityPane<?, ?> context) {
        Mode mode = this.getMode(context);
        String name = null;
        if (mode == null || mode == Mode.RESTORE_START) {
            name = Messages.personalDataRestrictionPersonRestoreStart;
        } else if (mode == Mode.RESTORE_STOP) {
            name = Messages.personalDataRestrictionPersonRestoreStop;
        }
        return name != null ? name : "";
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        Mode mode = this.getMode(context);
        String description = null;
        if (mode == null || mode == Mode.RESTORE_START) {
            description = Messages.personalDataRestrictionPersonRestoreStartDescription;
        } else if (mode == Mode.RESTORE_STOP) {
            description = Messages.personalDataRestrictionPersonRestoreStopDescription;
        }
        return description != null ? description : "";
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        StandardActionIcons icon = null;
        Mode mode = this.getMode(context);
        if (mode == Mode.RESTORE_START) {
            icon = StandardActionIcons.PLAY;
        } else if (mode == Mode.RESTORE_STOP) {
            icon = StandardActionIcons.STOP;
        }
        return icon != null ? icon : StandardActionIcons.PLAY;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && PersonalDataPersonRequest.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        Mode mode = this.getMode(context);
        PersonalDataRequestType type = this.getType(context);
        return context.getMode() != EditingMode.CREATE && context.getMode() != EditingMode.VIEW && mode != null && type == PersonalDataRequestType.RESTRICTION_PERSON;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        PersonalDataRequestType type = this.getType(context);
        Mode mode = this.getMode(context);
        if (type != null && mode != null) {
            EntityContainer requestContainer = context.getData().getContainer();
            RootEntityPane.executeAction(context, () -> Notifications.get().submitTask(() -> {
                if (mode == Mode.RESTORE_START) {
                    ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).restrictionPersonRestoreStart(ServiceInvocationContext.get(), requestContainer.toReference());
                } else if (mode == Mode.RESTORE_STOP) {
                    ((PersonalDataService)RpcServiceManager.get().getService(PersonalDataService.class)).restrictionPersonRestoreStop(ServiceInvocationContext.get(), requestContainer.toReference());
                }
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(requestContainer.toReference(), EntityModification.ModificationType.CHANGE)));
            }, context.getMutex()));
        }
    }

    private PersonalDataRequestType getType(RootEntityPane<?, ?> context) {
        return Optional.ofNullable(context.getData()).map(item -> item.getContainer()).map(item -> ((PersonalDataPersonRequest)item.getEntity()).getType()).orElse(null);
    }

    private Mode getMode(RootEntityPane<?, ?> context) {
        PersonalDataRequestStatus status = Optional.ofNullable(context.getData()).map(item -> item.getContainer()).map(item -> ((PersonalDataPersonRequest)item.getEntity()).getStatus()).orElse(null);
        if (status == PersonalDataRequestStatus.PROCESS_DONE || status == PersonalDataRequestStatus.RESTORE_INTERRUPTED || status == PersonalDataRequestStatus.RESTORE_FAILED) {
            return Mode.RESTORE_START;
        }
        if (status == PersonalDataRequestStatus.RESTORING) {
            return Mode.RESTORE_STOP;
        }
        return null;
    }

    private static enum Mode {
        RESTORE_START,
        RESTORE_STOP;

    }
}

