/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javafx.scene.control.Control;

public class CopyListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = new HashSet<Class>(Arrays.asList(AeroexpressTicketIndex.class, UniversalProductIndex.class, InsuranceAccidentIndex.class, DeliveryIndex.class, MainHotelProductIndex.class, InsuranceTouristicIndex.class, VisaProductIndex.class, AgencyMemoProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, MCOFeesIndex.class, ProductIndex.class, CommonProductIndex.class));

    public String getId() {
        return "product-copyInList";
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.COPY;
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        if (context.getSelectedItems().size() != 1) {
            return false;
        }
        if (context.getSelectedItems().get(0) == null) {
            return false;
        }
        if (context.getSelectedItems().get(0) instanceof CommonProductIndex) {
            return this.isEnabledForProductStatus(((CommonProductIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof AeroexpressTicketIndex) {
            return this.isEnabledForProductStatus(((AeroexpressTicketIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof UniversalProductIndex) {
            return this.isEnabledForProductStatus(((UniversalProductIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof InsuranceAccidentIndex) {
            return this.isEnabledForProductStatus(((InsuranceAccidentIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof DeliveryIndex) {
            return this.isEnabledForProductStatus(((DeliveryIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof MainHotelProductIndex) {
            return this.isEnabledForProductStatus(((MainHotelProductIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof InsuranceTouristicIndex) {
            return this.isEnabledForProductStatus(((InsuranceTouristicIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof VisaProductIndex) {
            return this.isEnabledForProductStatus(((VisaProductIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof AgencyMemoProductIndex) {
            return true;
        }
        if (context.getSelectedItems().get(0) instanceof TransferIndex) {
            return this.isEnabledForProductStatus(((TransferIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof CarRentalProductIndex) {
            return this.isEnabledForProductStatus(((CarRentalProductIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof MCOFeesIndex) {
            return this.isEnabledForProductStatus(((MCOFeesIndex)context.getSelectedItems().get(0)).getStatus());
        }
        if (context.getSelectedItems().get(0) instanceof ProductIndex) {
            return this.isEnabledForProductStatus(((ProductIndex)context.getSelectedItems().get(0)).getStatus());
        }
        return false;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        EntityIndex bfInd = (EntityIndex)selectedItems.get(0);
        CopyTask.showCopyDialog((EntityReference<BookingFile>)bfInd.getSource(), bfInd.getNavigationKey(), context, context.getMutex());
    }

    private boolean isEnabledForProductStatus(ProductStatus productStatus) {
        return productStatus == ProductStatus.SELL || productStatus == ProductStatus.BOOKING || ProductStatusHandler.getAllVoidStatuses().contains(productStatus);
    }

    private boolean isEnabledForProductStatus(DeliveryStatus productStatus) {
        return productStatus == DeliveryStatus.VOID || productStatus == DeliveryStatus.PLANNED || productStatus == DeliveryStatus.COMPLETED;
    }
}

