/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.gdsnames.GdsSettingsHelper;
import com.gridnine.xtrip.client.fx.standard.tasks.ReSubmitMode;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javax.naming.OperationNotSupportedException;

public class ReSubmissionTask
extends ClientTask {
    private final ReSubmitMode mode;
    private final BaseProduct srcProduct;
    private final String ticketNum;
    private final GdsName gdsName;
    private final RecordLocatorType recordLocatorType;
    private final String reservationNum;
    private final EntityReference<BookingFile> srcBookingFileEntityReference;
    private final EntityReference<Organization> targetClient;
    private final EntityReference<Contract> targetContract;

    protected String getTitle() {
        return Messages.re_submission_of_the_ticket;
    }

    private ReSubmissionTask(ReSubmitMode aMode, BaseProduct aProduct, EntityReference<BookingFile> aBookingFileEntityReference, String ticketNum, GdsName gdsName, RecordLocatorType recordLocatorType, String aReservationNum, EntityReference<Organization> targetClient, EntityReference<Contract> targetContract) {
        this.mode = aMode;
        this.srcProduct = aProduct;
        this.srcBookingFileEntityReference = aBookingFileEntityReference;
        this.ticketNum = ticketNum;
        this.gdsName = gdsName;
        this.recordLocatorType = recordLocatorType;
        this.reservationNum = aReservationNum;
        this.targetClient = targetClient;
        this.targetContract = targetContract;
    }

    public static void showReSubmissionDialog(EntityContainer<BookingFile> bookingCtr, String productUid, Node context, ObservableMutex mutex) {
        Notifications.get().submitTask(() -> {
            AgencyMemoProduct selectedProduct = (AgencyMemoProduct)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bookingCtr.getEntity()), AgencyMemoProduct.class);
            FxUtil.submitToFxThread(() -> ReSubmissionTask.showReSubmissionDialogInt(selectedProduct, bookingCtr, context));
        }, mutex);
    }

    private static IndexListParameters<Contract, ContractCustomerIndex> findIndexListparams(EntityReference<Organization> organization, EntityReference<Organization> agency) {
        IndexListParameters<Contract, ContractCustomerIndex> contractParameters = ControllerInterceptorsHelper.getContracts(organization, agency);
        contractParameters.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), agency));
        contractParameters.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), organization));
        return contractParameters;
    }

    private static void showReSubmissionDialogInt(AgencyMemoProduct product, EntityContainer<BookingFile> bookingCtr, Node context) {
        RadioBoxWidget modeBox = new RadioBoxWidget(false);
        TextFieldWidget ticketNum = new TextFieldWidget(false);
        String systemNumber = product.getSystemNumber();
        ticketNum.setValue(systemNumber);
        EntityReference agency = product.getAgency();
        GridCell radioBoxCell = new GridCell(Messages.Location_of_the_new_ticket, (Node)modeBox);
        radioBoxCell.setColSpan(Integer.MAX_VALUE);
        GridCell ticketNumCell = new GridCell(Messages.Number_of_ticket, (Node)ticketNum);
        ComboBoxWidget gdsName = new ComboBoxWidget(false);
        GdsSettingsHelper.configureComboBoxWidget((ComboBoxWidget<GdsName>)gdsName);
        gdsName.setValue(null);
        GridCell gdsNameCell = new GridCell(Messages.Gds, (Node)gdsName);
        gdsName.getViewState().setNotEditable(true);
        ComboBoxWidget recordLocatorType = new ComboBoxWidget(false);
        recordLocatorType.setItemsSupplier(Suppliers.createEnumSupplier(RecordLocatorType.class));
        recordLocatorType.setValue(null);
        GridCell recordLocatorTypeCell = new GridCell(Messages.Record_locator_type, (Node)recordLocatorType);
        recordLocatorType.getViewState().setNotEditable(true);
        TextFieldWidget bookingNum = new TextFieldWidget(false);
        bookingNum.setValue(null);
        GridCell bookingNumCell = new GridCell(Messages.Booking_number, (Node)bookingNum);
        bookingNum.getViewState().setNotEditable(true);
        EntityBoxWidget client = new EntityBoxWidget(Organization.class, false);
        GridCell clientCell = new GridCell(Messages.Client, (Node)client);
        EntityBoxWidget contract = new EntityBoxWidget(Contract.class, false);
        client.setValue(((BookingFile)bookingCtr.getEntity()).getCustomerProfile());
        FxUtil.addListener((ObservableValue)client.valueProperty(), (observable, oldValue, newValue) -> {
            if (MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                return;
            }
            Notifications.get().submitTask(() -> {
                Runnable setNullContract = () -> contract.setValue(null);
                if (newValue == null) {
                    FxUtil.submitToFxThread((Runnable)setNullContract);
                    return;
                }
                IndexListParameters<Contract, ContractCustomerIndex> contractParams = ReSubmissionTask.findIndexListparams((EntityReference<Organization>)newValue, (EntityReference<Organization>)agency);
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().addAll(contractParams.getSearchCriterions());
                query.getPreferredProperties().add(ContractIndex.Property.name.name());
                try {
                    List indexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), ContractIndex.class, query);
                    if (indexes.size() == 1) {
                        FxUtil.submitToFxThread(() -> contract.setValue(((ContractIndex)indexes.get(0)).getSource()));
                    } else {
                        FxUtil.submitToFxThread((Runnable)setNullContract);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430 \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u0430\u0433\u0435\u043d\u0442\u0430");
        });
        GridCell contractCell = new GridCell(Messages.contract_fx_gui, (Node)contract);
        contract.setListParametersSupplier(() -> ReSubmissionTask.findIndexListparams((EntityReference<Organization>)client.getValue(), (EntityReference<Organization>)agency));
        modeBox.valueProperty().addListener((obj, o, n) -> {
            List reservations = ((BookingFile)bookingCtr.getEntity()).getReservations();
            if (n == ReSubmitMode.SAME_RESERVATION) {
                gdsName.getViewState().setNotEditable(true);
                gdsName.setValue(null);
                recordLocatorType.getViewState().setNotEditable(true);
                recordLocatorType.setValue(null);
                bookingNum.getViewState().setNotEditable(true);
                bookingNum.setValue(null);
            } else if (n == ReSubmitMode.NEW_BOOKING_FILE && reservations != null && reservations.get(0) != null) {
                for (ReservationSystemInfo systemInfo : ((Reservation)reservations.get(0)).getGdsNameInfo().getSystemInfos()) {
                    for (RecordLocatorInfo recordLocator : systemInfo.getRecordLocators()) {
                        if (!recordLocator.isDisplay()) continue;
                        gdsName.setValue((Object)systemInfo.getGdsName());
                        gdsName.getViewState().setNotEditable(false);
                        recordLocatorType.setValue((Object)recordLocator.getType());
                        recordLocatorType.getViewState().setNotEditable(false);
                        bookingNum.setValue(recordLocator.getRecordLocator());
                        bookingNum.getViewState().setNotEditable(false);
                    }
                }
            } else {
                gdsName.getViewState().setNotEditable(false);
                recordLocatorType.getViewState().setNotEditable(false);
                bookingNum.getViewState().setNotEditable(false);
            }
        });
        EntityBoxWidget payersWidget = new EntityBoxWidget(Organization.class, true);
        GridCell payersCell = new GridCell(Messages.Payers, (Node)payersWidget);
        payersWidget.setValue(agency);
        GridContainer container = new GridContainer(3);
        container.setStyle("-fx-pref-width: 60em;");
        container.getCells().addAll((Object[])new GridCell[]{radioBoxCell, ticketNumCell, gdsNameCell, recordLocatorTypeCell, bookingNumCell, payersCell, clientCell, contractCell});
        Dialog result = new Dialog().setTitle(Messages.re_submission_of_the_ticket).setBody((Node)container);
        modeBox.setItemsSupplier(Suppliers.createEnumSupplier(ReSubmitMode.class));
        modeBox.setValue((Object)ReSubmitMode.SAME_RESERVATION);
        result.setAutoClose(false).setOnCloseRequest(() -> ((Dialog)result).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.reSubmit_button_in_agency_memo, () -> {
            if (contract.getValue() == null) {
                result.setValidationMessages(true, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.no_contract_in_agency_memo, (Object[])new Object[0])});
            } else if (modeBox.getValue() == ReSubmitMode.NEW_BOOKING_FILE && TextUtil.isBlank((String)bookingNum.getValue())) {
                result.setValidationMessages(true, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_booking_number, (Object[])new Object[0])});
            } else if (ticketNum.getValue() == null) {
                result.setValidationMessages(true, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Missing_ticket_number, (Object[])new Object[0])});
            } else {
                Notifications.get().enqueueAsyncTask((ClientTask)new ReSubmissionTask((ReSubmitMode)((Object)((Object)modeBox.getValue())), (BaseProduct)product, (EntityReference<BookingFile>)bookingCtr.toReference(), ticketNum.getValue(), (GdsName)gdsName.getValue(), (RecordLocatorType)recordLocatorType.getValue(), bookingNum.getValue(), (EntityReference<Organization>)client.getValue(), (EntityReference<Contract>)contract.getValue()));
                result.close();
            }
        }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)result).close());
        result.show(context);
    }

    protected void execute() throws Exception {
        BookingFileService.BookingFileRPCResult bookingFileRPCResult;
        EntityReference sourceReference = this.srcBookingFileEntityReference;
        switch (this.mode) {
            case SAME_RESERVATION: {
                bookingFileRPCResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).reSubmitProductToSameReservation(ServiceInvocationContext.get(), this.srcProduct.getUid(), this.srcBookingFileEntityReference, this.ticketNum, this.targetClient, this.targetContract);
                break;
            }
            case NEW_BOOKING_FILE: {
                bookingFileRPCResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).reSubmitProductToNewBookingFile(ServiceInvocationContext.get(), this.srcProduct.getUid(), this.srcBookingFileEntityReference, this.gdsName, this.recordLocatorType, this.reservationNum, this.ticketNum, this.targetClient, this.targetContract);
                sourceReference = bookingFileRPCResult.getResultObject();
                break;
            }
            default: {
                throw new OperationNotSupportedException();
            }
        }
        List resultMessageList = bookingFileRPCResult.getResultMessageList();
        if (bookingFileRPCResult.getResultUid() == null) {
            Message nullError = new Message();
            nullError.setType(MessageType.ERROR);
            L10nMessage l10n = new L10nMessage();
            l10n.setKey(Messages.Copy_Error);
            nullError.setMessage(l10n);
            nullError.setDetails(this.srcProduct.getUid());
            resultMessageList.add(nullError);
            this.addMessages(resultMessageList);
            return;
        }
        this.addMessages(resultMessageList);
        if (resultMessageList.stream().noneMatch(message -> message.getType() == MessageType.ERROR || message.getType() == MessageType.WARNING)) {
            RootEntityEditingService.get().open(sourceReference, true, rootEntityPane -> {
                BookingFileSpace tilesSpace = (BookingFileSpace)rootEntityPane.getEditor();
                CompactNavigatorWidget navigator = (CompactNavigatorWidget)((BookingFileProductsFullPanel)tilesSpace.getProductsTile().getFullNode()).getContent();
                Node node = UiUtil.findViewWithModelUid((Iterable)navigator.getViews(), (String)bookingFileRPCResult.getResultUid());
                if (node == null) {
                    Notifications.get().submitTask(() -> {
                        rootEntityPane.reloadData();
                        FxUtil.waitForFxThread(() -> {
                            Node node2 = UiUtil.findViewWithModelUid((Iterable)navigator.getViews(), (String)bookingFileRPCResult.getResultUid());
                            if (node2 != null) {
                                tilesSpace.expand(tilesSpace.getProductsTile());
                                navigator.selectView(node2);
                            }
                        });
                    }, Messages.Notifications_getting_data);
                } else {
                    tilesSpace.expand(tilesSpace.getProductsTile());
                    navigator.selectView(node);
                }
            });
        }
        this.refreshView(this.srcBookingFileEntityReference);
    }

    private void refreshView(EntityReference<BookingFile> bookingFileEntityReference) {
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bookingFileEntityReference, EntityModification.ModificationType.CHANGE)));
    }
}

