/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.receipts;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receipts.ListReceiptsAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.VoucherDialog;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.InformationNoteType;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class ProductVoucherAction
implements ListReceiptsAction {
    public String getId() {
        return "hotel-product-voucher";
    }

    @Override
    public boolean isEnabled(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        if (dtp == null || dtp.getContainer() == null) {
            return false;
        }
        List<BaseProduct> products = this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity());
        return !products.isEmpty();
    }

    @Override
    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        BookingFile bf = (BookingFile)dtp.getContainer().getEntity();
        List<BaseProduct> products = this.getSuitableProducts(bf);
        Notifications.get().submitTask(() -> {
            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            DictQuery dictQuery = new DictQuery();
            dictQuery.getFields().add(InformationNote.Property.priority.name());
            dictQuery.getFields().add(BaseDictionary.Property.code.name());
            dictQuery.getFields().add(BaseDictionary.Property.translations.name());
            dictQuery.getCriterions().add(new DictQuery.SearchCriterion(InformationNote.Property.types.name(), new Object[0]));
            List notesEmptyTypes = dictService.search(sic, InformationNote.class, dictQuery);
            dictQuery.getCriterions().clear();
            dictQuery.getCriterions().add(new DictQuery.SearchCriterion(InformationNote.Property.types.name(), new Object[]{InformationNoteType.VOUCHER}));
            List notesVoucherTypes = dictService.search(sic, InformationNote.class, dictQuery);
            ArrayList<DictItem<InformationNote>> notes = new ArrayList<DictItem<InformationNote>>(notesEmptyTypes);
            notes.addAll(notesVoucherTypes);
            notes.sort((note1, note2) -> ((Integer)note1.getFields().get(InformationNote.Property.priority.name())).compareTo((Integer)note2.getFields().get(InformationNote.Property.priority.name())));
            Map<BaseProduct, EntityReference<BookingFile>> products2Bookings = products.stream().collect(Collectors.toMap(obj -> obj, obj -> dtp.getContainer().toReference()));
            String uidSelectedProduct = (String)((CompactNavigatorWidget)((BookingFileSpaceController)context.getEditor().getProperties().get((Object)"controller")).getProductsFull().getView().getContent()).getSelectedView().getProperties().get((Object)"model-uid");
            VoucherDialog dialog = new VoucherDialog(source, products2Bookings, notes, uidSelectedProduct);
            FxUtil.submitToFxThread(dialog::showDialog);
        }, context.getMutex());
    }

    @Override
    public String getName() {
        return Messages.Hotel_product_voucher;
    }

    private List<BaseProduct> getSuitableProducts(BookingFile bf) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        if (bf == null) {
            return result;
        }
        bf.getReservations().stream().flatMap(r -> r.getProducts().stream().filter(HotelProductHelper::isHotelProduct)).forEach(baseProduct -> {
            ProductStatus productStatus = ((HotelProduct)baseProduct).getStatus();
            if (!(ProductStatus.REFUND.equals((Object)productStatus) || ProductStatus.EXCHANGE.equals((Object)productStatus) || ProductStatusHandler.getAllVoidStatuses().contains(productStatus))) {
                result.add((BaseProduct)baseProduct);
            }
        });
        return result;
    }
}

