/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist.ListReceiptsActionFromList;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist.ProductItineraryReceiptListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist.ProductRefundReceiptListAction;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receiptslist.ProductVoucherListAction;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public class UnionReceiptsActionFromList
implements IndexListAction {
    public List<ListReceiptsActionFromList> getActions() {
        return Arrays.asList(new ProductItineraryReceiptListAction(), new ProductRefundReceiptListAction(), new ProductVoucherListAction());
    }

    public String getName(IndexListPane<?, ?> context) {
        return Messages.Union_receipts_name;
    }

    public String getDescription(IndexListPane<?, ?> context) {
        return Messages.Union_receipts_description;
    }

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.RECEIPT;
    }

    public double getWeight() {
        return 43.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return CommonProductIndex.class.equals((Object)context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return this.getActions().stream().anyMatch(action -> action.isEnabled(context)) && this.getActions().stream().anyMatch(action -> action.isAvailable(context));
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List enabledActions = this.getActions().stream().filter(action -> action.isAvailable(context) && action.isEnabled(context)).collect(Collectors.toList());
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> enabledActions);
        widget.setConverter((StringConverter)new StringConverter<ListReceiptsActionFromList>(){

            public String toString(ListReceiptsActionFromList object) {
                return object == null ? "" : object.getName();
            }

            public ListReceiptsActionFromList fromString(String string) {
                return null;
            }
        });
        widget.setSortItems(false);
        widget.setNoNulls(true);
        if (!enabledActions.isEmpty()) {
            widget.setValue(enabledActions.get(0));
        }
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(Messages.Choose_document_type).setBody((Node)widget).setActionCaption(Messages.Choose).setActionHandler(() -> {
            if (((ListReceiptsActionFromList)widget.getValue()).isEnabled(context)) {
                ((ListReceiptsActionFromList)widget.getValue()).execute(source, context, alt);
            }
        }).show((Region)source);
    }

    public String getId() {
        return "union-receipts-action-from-list";
    }
}

