/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javafx.scene.Node;

public abstract class BaseRootEntityHandler<E extends BaseEntity, S, VM, V extends Node>
implements RootEntityHandler<E, S> {
    List<BiConsumer<DataTransferPackage<E, S>, VM>> toVMtranslators;
    List<BiConsumer<VM, DataTransferPackage<E, S>>> fromVMtranslators;

    public final ViewController<?, DataTransferPackage<E, S>> createEditorController(final boolean ro) {
        if (this.toVMtranslators == null) {
            this.toVMtranslators = new ArrayList<BiConsumer<DataTransferPackage<E, S>, VM>>();
            this.fromVMtranslators = new ArrayList<BiConsumer<VM, DataTransferPackage<E, S>>>();
            this.configureController(this.toVMtranslators, this.fromVMtranslators);
        }
        return new ViewController<V, DataTransferPackage<E, S>>(){
            private final ViewController<V, VM> controller;
            private DataTransferPackage<E, S> data;
            {
                this.controller = BaseRootEntityHandler.this.createSpaceController(ro);
            }

            public void enforceAcl(AppliedAclData aclData, String parentId) {
                this.controller.enforceAcl(aclData, parentId);
            }

            public boolean isDataAclEnforceable() {
                return this.controller.isDataAclEnforceable();
            }

            public void enforceDataAcl(ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
                this.controller.enforceDataAcl(rootController, deniedPermissions);
            }

            public V getView() {
                return this.controller.getView();
            }

            public DataTransferPackage<E, S> getData() {
                return this.data;
            }

            public void readData(DataTransferPackage<E, S> model) {
                try {
                    this.data = model;
                    Object vm = BaseRootEntityHandler.this.createVM();
                    BaseRootEntityHandler.this.toVMtranslators.forEach(tr -> tr.accept(model, vm));
                    this.controller.readData(vm);
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"unexpected error during data reading, handler={0}, data={1}", (Throwable)e, (Object[])new Object[]{BaseRootEntityHandler.this.getClass().getName(), model});
                }
            }

            public void writeData(DataTransferPackage<E, S> model) {
                try {
                    this.data = model;
                    Object vm = BaseRootEntityHandler.this.createVM();
                    BaseRootEntityHandler.this.toVMtranslators.forEach(tr -> tr.accept(model, vm));
                    this.controller.writeData(vm);
                    BaseRootEntityHandler.this.fromVMtranslators.forEach(tr -> tr.accept(vm, model));
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"unexpected error during data writing, handler={0}, data={1}", (Throwable)e, (Object[])new Object[]{BaseRootEntityHandler.this.getClass().getName(), model});
                }
            }

            public boolean isReadonly() {
                return this.controller.isReadonly();
            }

            public void setReadonly(boolean readonly) {
                this.controller.setReadonly(readonly);
            }

            public void setNotEditable(boolean notEditable) {
                this.controller.setNotEditable(notEditable);
            }

            public void setAclNotEditable(boolean aclNotEditable) {
                this.controller.setAclNotEditable(aclNotEditable);
            }

            public boolean isDataChanged() {
                return this.controller.isDataChanged();
            }

            public void validateData(List<Message> messages) {
                this.controller.validateData(messages);
            }
        };
    }

    protected abstract void configureController(List<BiConsumer<DataTransferPackage<E, S>, VM>> var1, List<BiConsumer<VM, DataTransferPackage<E, S>>> var2);

    protected abstract ViewController<V, VM> createSpaceController(boolean var1);

    protected abstract VM createVM();

    public boolean isAvaibleInConfiguration() {
        EntityType ett = (EntityType)MetaRegistry.get().getEntities().get(this.getEntityClass().getName());
        return AppConfigHelper.isInScope(ett);
    }
}

