/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.CompanyGroupContainer;
import com.gridnine.xtrip.client.fx.model.profile.CompanyGroupSpace;
import com.gridnine.xtrip.client.fx.model.profile.CompanyGroupSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.CompanyGroupSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.CompanyGroupControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.person.uidata.CompanyGroupUIData;
import com.gridnine.xtrip.common.model.profile.CompanyGroup;
import com.gridnine.xtrip.common.model.profile.CompanyGroupIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class CompanyGroupHandler
extends BaseRootEntityHandler<CompanyGroup, CompanyGroupUIData, CompanyGroupSpaceVM, CompanyGroupSpace> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<CompanyGroup, CompanyGroupUIData>, CompanyGroupSpaceVM>> toVM, List<BiConsumer<CompanyGroupSpaceVM, DataTransferPackage<CompanyGroup, CompanyGroupUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CompanyGroupControllerInterceptor());
        toVM.add((dtp, vm) -> {
            CompanyGroup model = (CompanyGroup)dtp.getContainer().getEntity();
            vm.getGeneralFull().setFullName(model.getFullName());
            vm.getGeneralFull().setShortName(model.getShortName());
            vm.getGeneralFull().setHolding(model.getHolding());
            vm.getGeneralFull().getClients().clear();
            vm.getGeneralFull().getClients().addAll(((CompanyGroupUIData)dtp.getSupplement()).getOrganisations());
        });
        fromVM.add((vm, dtp) -> {
            CompanyGroup model = (CompanyGroup)dtp.getContainer().getEntity();
            model.setHolding(vm.getGeneralFull().getHolding());
            VMHelper.fromVM(vm.getGeneralFull().getShortName(), model.getShortName());
            VMHelper.fromVM(vm.getGeneralFull().getFullName(), model.getFullName());
        });
    }

    @Override
    protected ViewController<CompanyGroupSpace, CompanyGroupSpaceVM> createSpaceController(boolean readonly) {
        return new CompanyGroupSpaceController(readonly);
    }

    @Override
    protected CompanyGroupSpaceVM createVM() {
        return new CompanyGroupSpaceVM();
    }

    public Class<CompanyGroup> getEntityClass() {
        return CompanyGroup.class;
    }

    public Class<CompanyGroupUIData> getSupplementClass() {
        return CompanyGroupUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return CompanyGroupIndex.class;
    }

    public List<RootEntityEditorInterceptor<CompanyGroup, CompanyGroupUIData>> getEditorInterceptors() {
        return Collections.singletonList(new RootEntityEditorInterceptor<CompanyGroup, CompanyGroupUIData>(){

            public void onLoad(DataTransferPackage<CompanyGroup, CompanyGroupUIData> data, Node editor) {
            }

            public boolean onSave(DataTransferPackage<CompanyGroup, CompanyGroupUIData> data, Node editor) {
                EntityContainer clientCtr;
                EntityReference holding = ((CompanyGroupContainer)((CompanyGroupSpace)editor).getGeneralTile().getFullNode()).getHoldingNode().getValue();
                ObservableList clientsValues = ((CompanyGroupContainer)((CompanyGroupSpace)editor).getGeneralTile().getFullNode()).getClientsNode().getValues();
                EntityReference groupRef = data.getContainer().toReference();
                List clientsUIData = ((CompanyGroupUIData)data.getSupplement()).getOrganisations();
                Set clients = Stream.concat(clientsValues.stream(), clientsUIData.stream()).collect(Collectors.toSet());
                HashMap<EntityReference, EntityContainer> organizations = new HashMap<EntityReference, EntityContainer>();
                for (EntityReference clientRef : clients) {
                    try {
                        clientCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), clientRef);
                        organizations.put(clientRef, clientCtr);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }
                for (EntityReference clientRef : clientsValues) {
                    clientCtr = (EntityContainer)organizations.get(clientRef);
                    if (holding == null || holding.equals((Object)((Organization)clientCtr.getEntity()).getHolding())) continue;
                    try {
                        FxUtil.waitForFxThread(() -> ((CompanyGroupSpace)editor).setMessages(Collections.singletonList(Messages.getCompanyGroupHoldingMismatch())));
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                    return false;
                }
                for (EntityReference clientRef : clients) {
                    try {
                        EntityReference localGroupRef;
                        clientCtr = (EntityContainer)organizations.get(clientRef);
                        Object object = localGroupRef = clientsValues.contains((Object)clientRef) ? groupRef : null;
                        if (MiscUtil.equals((Object)((Organization)clientCtr.getEntity()).getCompanyGroup(), (Object)localGroupRef)) continue;
                        ((Organization)clientCtr.getEntity()).setCompanyGroup(localGroupRef);
                        ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), clientCtr, null, true);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }
                return true;
            }
        });
    }
}

