/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ValuesWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.model.profile.ETicketQuotaContainer;
import com.gridnine.xtrip.client.fx.model.profile.ETicketQuotaGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.ETicketQuotaSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.ETicketQuotaSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.ETicketQuotaVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ETicketQuotaControllerInterceptor
extends ControllerInterceptor<ETicketQuotaSpaceVM, ETicketQuotaSpaceController> {
    private static final String EMPTY_KEY = "empty";
    private static final MultiSupplier<IndexListParameters<BaseProfile, ?>> CURRENT_LOCATION_SUPPLIER = new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){
        private final IndexListParameters<?, ?>[] listParameters = new IndexListParameters[]{ControllerInterceptorsHelper.getAgencies(), ControllerInterceptorsHelper.getSalesPoints()};

        public String getDisplayName(int idx) {
            return MetaRegistryHelper.getDisplayName((Class)this.listParameters[idx].getIndexType());
        }

        public IndexListParameters<BaseProfile, ?> get(int idx) {
            return this.listParameters[idx];
        }

        public int count() {
            return this.listParameters.length;
        }
    };

    ETicketQuotaControllerInterceptor() {
    }

    protected void onCreate(ETicketQuotaSpaceController controller) {
        TableWidget quotasTable = (TableWidget)((ETicketQuotaContainer)controller.getView().getMainTile().getFullNode()).getQuotasCard().getContent();
        DictBoxWidgetColumn blankTypeColumn = (DictBoxWidgetColumn)quotasTable.getColumn("blankType");
        ValuesWidgetColumn gdsColumn = (ValuesWidgetColumn)quotasTable.getColumn("gds");
        HashMap<String, Set<GdsName>> alreadyAssignedGDS = new HashMap<String, Set<GdsName>>();
        ETicketQuotaControllerInterceptor.setStringConverters(controller);
        ETicketQuotaControllerInterceptor.setGerenalPanelSuppliers(controller);
        ETicketQuotaGeneralPanel generalPanel = (ETicketQuotaGeneralPanel)((ETicketQuotaContainer)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent();
        ETicketQuotaControllerInterceptor.setTableWidgetListeners((DictBoxWidgetColumn<ETicketQuotaVM, BlankType>)blankTypeColumn, (ValuesWidgetColumn<ETicketQuotaVM, GdsName>)gdsColumn, (TableWidget<ETicketQuotaVM>)quotasTable, generalPanel, alreadyAssignedGDS);
    }

    protected Class<ETicketQuotaSpaceController> getControllerClass() {
        return ETicketQuotaSpaceController.class;
    }

    private static void setTableWidgetListeners(DictBoxWidgetColumn<ETicketQuotaVM, BlankType> blankTypeColumn, ValuesWidgetColumn<ETicketQuotaVM, GdsName> gdsColumn, TableWidget<ETicketQuotaVM> quotasTable, ETicketQuotaGeneralPanel generalPanel, Map<String, Set<GdsName>> alreadyAssignedGDS) {
        quotasTable.setOnRowsAction(event -> {
            int rowIdx = event.getRowIndex();
            if (TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                ETicketQuotaControllerInterceptor.updateAssignedGDSList(blankTypeColumn, gdsColumn, quotasTable, alreadyAssignedGDS);
                ETicketQuotaControllerInterceptor.setGDSSupplier(rowIdx, blankTypeColumn, gdsColumn, quotasTable, alreadyAssignedGDS);
                ETicketQuotaControllerInterceptor.setBlankTypeSupplier(rowIdx, blankTypeColumn, gdsColumn, quotasTable, generalPanel, alreadyAssignedGDS);
            } else if (TableRowEvent.ROW_REMOVE.equals(event.getEventType())) {
                ETicketQuotaControllerInterceptor.updateAssignedGDSList(blankTypeColumn, gdsColumn, quotasTable, alreadyAssignedGDS);
            }
        });
    }

    private static void updateAssignedGDSList(DictBoxWidgetColumn<ETicketQuotaVM, BlankType> blankTypeColumn, ValuesWidgetColumn<ETicketQuotaVM, GdsName> gdsColumn, TableWidget<ETicketQuotaVM> quotasTable, Map<String, Set<GdsName>> alreadyAssignedGDS) {
        alreadyAssignedGDS.clear();
        for (int i = 0; i < quotasTable.getRowsCount(); ++i) {
            DictionaryReference currentRowBlankType = ((DictBoxWidget)blankTypeColumn.getWidget(i)).getValue();
            String currentRowKey = currentRowBlankType == null ? EMPTY_KEY : currentRowBlankType.getCode().toString();
            HashSet currentRowValues = new HashSet(((ValuesWidget)gdsColumn.getWidget(i)).getValues());
            Set<GdsName> blankTypeValues = alreadyAssignedGDS.get(currentRowKey);
            if (blankTypeValues == null) {
                alreadyAssignedGDS.put(currentRowKey, currentRowValues);
                continue;
            }
            blankTypeValues.addAll(currentRowValues);
        }
    }

    private static void setGerenalPanelSuppliers(ETicketQuotaSpaceController controller) {
        ETicketQuotaGeneralPanel generalPanel = (ETicketQuotaGeneralPanel)((ETicketQuotaContainer)controller.getView().getMainTile().getFullNode()).getGeneralCard().getContent();
        generalPanel.getBlankOwnerNode().setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        generalPanel.getStockHolderNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        generalPanel.getCurrentLocationNode().setListParametersSupplier(CURRENT_LOCATION_SUPPLIER);
    }

    private static void setGDSSupplier(int rowIdx, DictBoxWidgetColumn<ETicketQuotaVM, BlankType> blankTypeColumn, ValuesWidgetColumn<ETicketQuotaVM, GdsName> gdsColumn, TableWidget<ETicketQuotaVM> quotasTable, Map<String, Set<GdsName>> alreadyAssignedGDS) {
        ValuesWidget gdsWidget = (ValuesWidget)gdsColumn.getWidget(rowIdx);
        gdsWidget.setItemsSupplier(Suppliers.createEnumSupplier(GdsName.class, p -> {
            Set blankTypeValues;
            DictionaryReference blankType = ((DictBoxWidget)blankTypeColumn.getWidget(rowIdx)).getValue();
            Set set = blankTypeValues = blankType == null ? (Set)alreadyAssignedGDS.get(EMPTY_KEY) : (Set)alreadyAssignedGDS.get(blankType.getCode().toString());
            return blankTypeValues == null ? true : !blankTypeValues.contains(p) || gdsWidget.getValues().contains(p);
        }));
        gdsWidget.getValues().addListener(change -> ETicketQuotaControllerInterceptor.updateAssignedGDSList(blankTypeColumn, gdsColumn, quotasTable, alreadyAssignedGDS));
    }

    private static void setBlankTypeSupplier(int rowIdx, DictBoxWidgetColumn<ETicketQuotaVM, BlankType> blankTypeColumn, ValuesWidgetColumn<ETicketQuotaVM, GdsName> gdsColumn, TableWidget<ETicketQuotaVM> quotasTable, ETicketQuotaGeneralPanel generalPanel, Map<String, Set<GdsName>> alreadyAssignedGDS) {
        DictBoxWidget blankTypeWidget = (DictBoxWidget)blankTypeColumn.getWidget(rowIdx);
        blankTypeWidget.setListParametersSupplier(() -> {
            DictListParameters dictListParameters = new DictListParameters();
            TableColumnSettings blankType = new TableColumnSettings();
            blankType.setId(BaseDictionary.Property.code.name());
            blankType.setDisplayName(Messages.QuotaHendler_Form_ID);
            blankType.setRenderer((Renderer)StandardRenderers.DICT_CODE);
            dictListParameters.getColumns().add(blankType);
            dictListParameters.getFilters().add(blankType);
            EntityReference blankOwner = generalPanel.getBlankOwnerNode().getValue();
            if (blankOwner != null) {
                dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.blankOwner.name(), new Object[]{blankOwner}));
            }
            dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.blankCategory.name(), new Object[]{BlankCategory.ETICKET}));
            return dictListParameters;
        });
        blankTypeWidget.valueProperty().addListener(o -> ETicketQuotaControllerInterceptor.updateAssignedGDSList(blankTypeColumn, gdsColumn, quotasTable, alreadyAssignedGDS));
    }

    private static void setStringConverters(ETicketQuotaSpaceController main) {
        ((ETicketQuotaGeneralPanel)((ETicketQuotaContainer)main.getView().getMainTile().getFullNode()).getGeneralCard().getContent()).getRestoreUnvoidNode().setConverter(Converters.boolConverter((String)Messages.QuotaHendler_Restore_quota, (String)Messages.QuotaHendler_Dont_Restore_quota));
    }
}

