/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsPaymentTypesSettingsVM;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsSpaceController;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsSpaceVM;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalFilteringCategories;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.Arrays;
import java.util.stream.Collectors;
import javafx.scene.Node;

class FiscalSettingsSpaceControllerInterceptor
extends ControllerInterceptor<FiscalSettingsSpaceVM, FiscalSettingsSpaceController> {
    FiscalSettingsSpaceControllerInterceptor() {
    }

    protected Class<FiscalSettingsSpaceController> getControllerClass() {
        return FiscalSettingsSpaceController.class;
    }

    protected void onCreate(FiscalSettingsSpaceController controller) {
        RulesViewConfiguration config = new RulesViewConfiguration();
        config.getFilters().addAll(Arrays.asList(StandardFilters.values()));
        config.getCategories().add((RuleFilteringCategory)FiscalFilteringCategories.FISCAL_RECEIPT);
        RulesWidgetHelper.initTile((Tile<Node, CustomWidget<RuleSet>>)controller.getView().getRulesTile(), config);
        TableWidget tableWidget = controller.getSettingsFull().getView().getPaymentTypesSettingsNode();
        tableWidget.setOnRowsAction(event -> {
            if (event.getTarget() != tableWidget) {
                return;
            }
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex();
                ComboBoxWidget midofficePaymentTypeWgt = (ComboBoxWidget)tableWidget.getColumn("midofficePaymentType").getWidget(rowIndex);
                ComboBoxWidget kktPaymentTypeWgt = (ComboBoxWidget)tableWidget.getColumn("kktPaymentType").getWidget(rowIndex);
                midofficePaymentTypeWgt.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes().stream().filter(type -> type != PaymentType.CASH && type != PaymentType.TICKET && type != PaymentType.CREDIT_CARD_AGENCY && type != PaymentType.CREDIT_CARD && type != PaymentType.CREDIT_CARD_TCH && !tableWidget.getRowsData().stream().map(FiscalSettingsPaymentTypesSettingsVM::getMidofficePaymentType).collect(Collectors.toSet()).contains(type)).collect(Collectors.toList()));
                kktPaymentTypeWgt.setItemsSupplier(() -> Arrays.asList(com.gridnine.xtrip.common.model.fiscal.PaymentType.CASH, com.gridnine.xtrip.common.model.fiscal.PaymentType.ELECTRONIC));
            }
        });
    }
}

