/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.system.TrashBinItemPane;
import com.gridnine.xtrip.client.fx.model.system.TrashBinItemPaneController;
import com.gridnine.xtrip.client.fx.model.system.TrashBinItemPaneVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.scene.Node;

public class TrashBinItemHandler
extends BaseRootEntityHandler<TrashBinItem, Void, TrashBinItemPaneVM, TrashBinItemPane> {
    public Class<TrashBinItem> getEntityClass() {
        return TrashBinItem.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TrashBinItemIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<TrashBinItem, Void>, TrashBinItemPaneVM>> toVM, List<BiConsumer<TrashBinItemPaneVM, DataTransferPackage<TrashBinItem, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new TrashBinItemPaneControllerInterceptor());
        toVM.add((dtp, vm) -> {
            TrashBinItem model = (TrashBinItem)dtp.getContainer().getEntity();
            vm.setType(model.getType());
            vm.setDescription(model.getDescription());
            vm.setNumber(model.getNumber());
            vm.setCreated(DateUtils.asLocalDateTime((Date)model.getCreated()));
            vm.setCreatedBy(model.getCreatedBy());
            vm.setCreatingAgent(model.getCreatingAgent());
            vm.setDeleted(DateUtils.asLocalDateTime((Date)model.getDeleted()));
            vm.setDeletedBy(model.getDeletedBy());
            vm.setDeletingAgent(model.getDeletingAgent());
        });
    }

    @Override
    protected ViewController<TrashBinItemPane, TrashBinItemPaneVM> createSpaceController(boolean readonly) {
        return new TrashBinItemPaneController(readonly);
    }

    @Override
    protected TrashBinItemPaneVM createVM() {
        return new TrashBinItemPaneVM();
    }

    private static class TrashBinItemPaneControllerInterceptor
    extends ControllerInterceptor<TrashBinItemPaneVM, TrashBinItemPaneController> {
        TrashBinItemPaneControllerInterceptor() {
        }

        protected Class<TrashBinItemPaneController> getControllerClass() {
            return TrashBinItemPaneController.class;
        }

        protected void afterReadData(TrashBinItemPaneController controller, TrashBinItemPaneVM model) {
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)controller.getView());
            if (rootEntityPane != null) {
                rootEntityPane.disableModeControls(true);
            }
        }
    }
}

