/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.WorkLogPanel;
import com.gridnine.xtrip.client.fx.model.profile.WorkLogPanelController;
import com.gridnine.xtrip.client.fx.model.profile.WorkLogPanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.WorkLogControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class WorkLogHandler
extends BaseRootEntityHandler<Worklog, Void, WorkLogPanelVM, WorkLogPanel> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return WorklogIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<Worklog, Void>, WorkLogPanelVM>> toVM, List<BiConsumer<WorkLogPanelVM, DataTransferPackage<Worklog, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new WorkLogControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Worklog model = (Worklog)dtp.getContainer().getEntity();
            vm.setEmployee(model.getEmployee());
            vm.setAgency(model.getAgency());
            vm.setSalesPoint(model.getSalesPoint());
            vm.setCash(model.getCash());
            vm.setCashRegister(model.getCashRegister());
            vm.setCashRegisterWorkplace(model.getCashRegisterWorkplace());
            vm.setForcedEnd(model.isForcedEnd());
            vm.setStartDate(DateUtils.asLocalDateTime((Date)model.getStartDate()));
            vm.setEndDate(DateUtils.asLocalDateTime((Date)model.getEndDate()));
            VMHelper.transfer(model.getTypes(), vm.getTypes());
        });
        fromVM.add((vm, dtp) -> {
            Worklog model = (Worklog)dtp.getContainer().getEntity();
            model.setEmployee(vm.getEmployee());
            model.setAgency(vm.getAgency());
            model.setSalesPoint(vm.getSalesPoint());
            model.setCash(vm.getCash());
            model.setCashRegister(vm.getCashRegister());
            model.setCashRegisterWorkplace(vm.getCashRegisterWorkplace());
            model.setForcedEnd(vm.isForcedEnd());
            model.setStartDate(DateUtils.asDate((LocalDateTime)vm.getStartDate()));
            model.setEndDate(DateUtils.asDate((LocalDateTime)vm.getEndDate()));
            VMHelper.transfer(vm.getTypes(), model.getTypes());
        });
    }

    public Class<Worklog> getEntityClass() {
        return Worklog.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<WorkLogPanel, WorkLogPanelVM> createSpaceController(boolean readonly) {
        return new WorkLogPanelController(readonly);
    }

    @Override
    protected WorkLogPanelVM createVM() {
        return new WorkLogPanelVM();
    }
}

