/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAppliedRulesDataViewVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAppliedRulesFullPanelVM;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.Date;
import java.util.HashMap;

final class AppliedRulesTileHelper {
    private AppliedRulesTileHelper() {
    }

    static void toVM(BookingFile model, BookingFileUIData uiData, BookingFileAppliedRulesFullPanelVM full) {
        full.getContent().clear();
        if (model.getAppliedRules().isEmpty()) {
            return;
        }
        HashMap productsMap = new HashMap();
        if (uiData != null) {
            uiData.getProducts().forEach(productData -> productsMap.put(productData.getRelatedProductUID(), productData));
        }
        model.getAppliedRules().forEach(rule -> {
            if (productsMap.get(rule.getProductUid()) != null) {
                BookingFileAppliedRulesDataViewVM ruleVM = new BookingFileAppliedRulesDataViewVM();
                ruleVM.setService(AppliedRulesTileHelper.getProductShortName(model, rule.getProductUid()));
                if (rule.getContract() != null) {
                    ruleVM.setContract(rule.getContract().getCaption());
                }
                ruleVM.setName(rule.getRuleName());
                ruleVM.setDescription(rule.getRuleDescription());
                ruleVM.setDate(DateUtils.asLocalDate((Date)rule.getCalculationDate()).toString());
                ruleVM.setContractReference(rule.getContract());
                if (rule.getRulesContainer() != null && !rule.getRulesContainer().equals((Object)rule.getContract())) {
                    ruleVM.setRulesContainer(rule.getRulesContainer().getCaption());
                    ruleVM.setRulesContainerReference(rule.getRulesContainer());
                }
                ruleVM.setRuleUid(rule.getRuleUid());
                full.getContent().add(ruleVM);
            }
        });
    }

    private static String getProductShortName(BookingFile bookingFile, String productUid) {
        BaseProduct baseProduct = BookingHelper.findProductByUid((String)productUid, (BookingFile)bookingFile);
        return BookingHelper.generateShortProductName((BaseProduct)baseProduct);
    }
}

