/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerBonusCardVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerDocumentPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.Date;

public final class TravelersTileHelper {
    static void toVM(BookingFile model, BookingFileTravelersPanelVM vm) {
        VMHelper.transfer(model.getTravellers(), vm.getContent(), name -> new BookingFileTravelerPanelVM(), (itemModel, itemVM) -> {
            BookingFileTravelerGeneralPanelVM generalParameters = itemVM.getGeneralParameters();
            generalParameters.setTraveller(itemModel);
            generalParameters.setName(itemModel.getName());
            generalParameters.setCyrillicName(itemModel.getCyrillicName());
            generalParameters.setNameInGds(itemModel.getNameInGds());
            generalParameters.setGender(itemModel.getGender());
            generalParameters.setTitle(itemModel.getTitle());
            generalParameters.setBirthday(DateUtils.asLocalDate((Date)itemModel.getBirthday()));
            generalParameters.setProfile(itemModel.getPassenger());
            Passport passport = itemModel.getPassport();
            if (passport != null) {
                BookingFileTravelerDocumentPanelVM document = itemVM.getDocuments();
                document.setLastName(passport.getLastName());
                document.setFirstName(passport.getFirstName());
                document.setSecondName(passport.getSecondName());
                document.setMiddleName(passport.getMiddleName());
                document.setGender(passport.getGender());
                document.setBirthday(DateUtils.asLocalDate((Date)passport.getBirthday()));
                document.setBirthPlace(passport.getBirthPlace());
                document.setDocumentType(passport.getType());
                document.setNumber(passport.getNumber());
                document.setIssued(DateUtils.asLocalDate((Date)passport.getIssued()));
                document.setExpired(DateUtils.asLocalDate((Date)passport.getExpired()));
                document.setCitizenship(passport.getCitizenship());
                document.setOriginCountry(passport.getOriginCountry());
                document.setIssueOrganization(passport.getIssueOrganization());
            }
            VMHelper.transfer(itemModel.getAirlineBonusCards(), itemVM.getBonusCards(), name -> new BookingFileTravelerBonusCardVM(), (bonusCardModel, bonusCardVM) -> {
                bonusCardVM.setNumber(bonusCardModel.getNumber());
                bonusCardVM.setAirline(bonusCardModel.getAirline());
                bonusCardVM.setAirlineApplied(bonusCardModel.getAirlineApplied());
                bonusCardVM.setValid(bonusCardModel.isValid());
            });
        });
    }

    public static void fromVM(BookingFileTravelersPanelVM vm, BookingFile model) {
        VMHelper.transfer(vm.getContent(), model.getTravellers(), name -> new Traveller(), (itemVM, itemModel) -> {
            BookingFileTravelerGeneralPanelVM generalParametersVM = itemVM.getGeneralParameters();
            if (generalParametersVM.getTraveller() != null) {
                itemModel.setUid(generalParametersVM.getTraveller().getUid());
            }
            itemModel.setName(generalParametersVM.getName());
            itemModel.setCyrillicName(generalParametersVM.getCyrillicName());
            itemModel.setNameInGds(generalParametersVM.getNameInGds());
            itemModel.setGender(generalParametersVM.getGender());
            itemModel.setTitle(generalParametersVM.getTitle());
            itemModel.setBirthday(DateUtils.asDate((LocalDate)generalParametersVM.getBirthday()));
            itemModel.setPassenger(generalParametersVM.getProfile());
            BookingFileTravelerDocumentPanelVM passportVM = itemVM.getDocuments();
            Passport passportModel = (Passport)MiscUtil.computeIfNull((Object)itemModel, Traveller::getPassport, Traveller::setPassport, Passport::new);
            passportModel.setLastName(passportVM.getLastName());
            passportModel.setFirstName(passportVM.getFirstName());
            passportModel.setSecondName(passportVM.getSecondName());
            passportModel.setMiddleName(passportVM.getMiddleName());
            passportModel.setGender(passportVM.getGender());
            passportModel.setBirthday(DateUtils.asDate((LocalDate)passportVM.getBirthday()));
            passportModel.setBirthPlace(passportVM.getBirthPlace());
            passportModel.setType(passportVM.getDocumentType());
            passportModel.setNumber(passportVM.getNumber());
            passportModel.setIssued(DateUtils.asDate((LocalDate)passportVM.getIssued()));
            passportModel.setExpired(DateUtils.asDate((LocalDate)passportVM.getExpired()));
            passportModel.setCitizenship(passportVM.getCitizenship());
            passportModel.setOriginCountry(passportVM.getOriginCountry());
            passportModel.setIssueOrganization(passportVM.getIssueOrganization());
            VMHelper.transfer(itemVM.getBonusCards(), itemModel.getAirlineBonusCards(), name -> new BookingAirlineBonusCard(), (bonusCardVM, bonusCardModel) -> {
                bonusCardModel.setNumber(bonusCardVM.getNumber());
                bonusCardModel.setAirline(bonusCardVM.getAirline());
                bonusCardModel.setAirlineApplied(bonusCardVM.getAirlineApplied());
                bonusCardModel.setValid(bonusCardVM.isValid());
            });
        });
    }
}

