/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.AirProductFopMapActionPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.ExchangePaymentTypeWrapperVM;
import com.gridnine.xtrip.client.fx.model.booking.PriceComponentWrapperVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.CostItem;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.ExchangePaymentTypeWrapper;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.FOPWrapper;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.FareCostItem;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.PenaltyCostItem;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.PriceComponentWrapper;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.TaxCostItem;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

class AirProductFopMapActionDialog {
    private TableWidgetController<TableWidget<ExchangePaymentTypeWrapperVM>, ExchangePaymentTypeWrapperVM> controllerPaymentTypes;
    private TableWidgetController<TableWidget<PriceComponentWrapperVM>, PriceComponentWrapperVM> controllerCostItem;
    private final List<FOPWrapper> availableFops = new ArrayList<FOPWrapper>();
    private final List<ExchangePaymentTypeWrapperVM> exchangePaymentTypes = new ArrayList<ExchangePaymentTypeWrapperVM>();
    private List<PriceComponentWrapperVM> priceComponents;
    private static final String MULTIPLE_UIDS_ALLOWED = "MULTIPLE_UIDS_ALLOWED";
    private static final String COST_ITEM_UID = "COST_ITEM_UID";
    private static final String FOP_WRAPPER_UID = "FOP_WRAPPER_UID";

    AirProductFopMapActionDialog() {
    }

    void executeAfterSaveRequired(Product product, Control source, Tile<Node, BookingFileProductsFullPanel> tile, boolean alt) {
        EntityReference<BookingFile> bFRef = this.getRefBF(tile);
        AirProductFopMapActionPanel body = this.createBody();
        Notifications.get().submitTask(() -> {
            this.loadData(product, bFRef);
            FxUtil.waitForFxThread(() -> {
                this.fillingBody(body);
                VBox box = new VBox(new Node[]{body});
                Dialog dialog = new Dialog();
                dialog.setAutoClose(false);
                dialog.setOnCloseRequest(() -> ((Dialog)dialog).close());
                dialog.setExpandToParent(true);
                dialog.setBody((Node)box).setTitle(Messages.Fop_map_dialog_tile).addButton(DialogButtonStyle.ACCEPT_CONTINUE, () -> {
                    String msg = this.writeAndValidateData();
                    if (msg != null) {
                        dialog.addValidationMessages(false, new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Object[])new Object[0])});
                    } else {
                        Notifications.get().submitTask(() -> {
                            ArrayList priceComponentsTemp = new ArrayList();
                            VMHelper.transfer(this.priceComponents, priceComponentsTemp, component -> {
                                PriceComponentWrapper res = new PriceComponentWrapper();
                                res.setPriceComponent(component.getPriceComponent());
                                for (ProductFare fare : product.getFares()) {
                                    if (!fare.getUid().equals(component.getPriceComponent().getUid())) continue;
                                    res.getPriceComponent().getFaresUids().add(component.getPriceComponent().getUid());
                                }
                                for (Tax tax : product.getTaxes()) {
                                    if (!tax.getUid().equals(component.getPriceComponent().getUid())) continue;
                                    res.getPriceComponent().getTaxesUids().add(component.getPriceComponent().getUid());
                                }
                                VMHelper.transfer(component.getFopUids(), res.getFopUids());
                                return res;
                            });
                            ArrayList exchangePaymentTypesTemp = new ArrayList();
                            VMHelper.transfer(this.exchangePaymentTypes, exchangePaymentTypesTemp, payment -> {
                                ExchangePaymentTypeWrapper res = new ExchangePaymentTypeWrapper();
                                res.setFop(payment.getFop());
                                res.setPaymentType(payment.getPaymentType());
                                return res;
                            });
                            ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).saveFopMap(ServiceInvocationContext.get(), bFRef, product.getUid(), priceComponentsTemp, exchangePaymentTypesTemp);
                            FxUtil.submitToFxThread(() -> dialog.close());
                        }, Messages.Notifications_saving_data);
                        Notifications.get().showStaticNotification(Messages.Notifications_changes_applied_saving_data, null);
                    }
                }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).show(tile.getFullNode());
            });
        }, Messages.Notifications_getting_data);
    }

    /*
     * WARNING - void declaration
     */
    private String writeAndValidateData() {
        void var2_5;
        this.controllerCostItem.writeData(this.priceComponents);
        this.controllerPaymentTypes.writeData(this.exchangePaymentTypes);
        for (PriceComponentWrapperVM priceComponentWrapperVM : this.priceComponents) {
            if (!priceComponentWrapperVM.getFopUids().isEmpty()) continue;
            String nameItem = "null";
            if (priceComponentWrapperVM.getPriceComponent() instanceof FareCostItem) {
                nameItem = String.format(Messages.Fop_map_fare, priceComponentWrapperVM.getPriceComponent().getAmount());
            }
            if (priceComponentWrapperVM.getPriceComponent() instanceof TaxCostItem) {
                nameItem = String.format(Messages.Fop_map_tax, ((TaxCostItem)priceComponentWrapperVM.getPriceComponent()).getTaxCode(), priceComponentWrapperVM.getPriceComponent().getAmount());
            }
            if (priceComponentWrapperVM.getPriceComponent() instanceof PenaltyCostItem) {
                nameItem = String.format(Messages.Fop_map_penalty, priceComponentWrapperVM.getPriceComponent().getAmount());
            }
            return String.format(Messages.Fop_map_validate_message_pricePartNotBinded, nameItem);
        }
        BigDecimal totalFop = BigDecimal.ZERO;
        for (FOPWrapper item : this.availableFops) {
            BigDecimal total = BigDecimal.ZERO;
            for (PriceComponentWrapperVM mapping : this.priceComponents) {
                if (!mapping.getFopUids().contains(item.getFopUid())) continue;
                total = total.add(mapping.getPriceComponent().isMultipleUidsAllowed() && mapping.getFopUids().size() > 1 ? BigDecimal.ZERO : mapping.getPriceComponent().getAmount());
            }
            if (total.compareTo(item.getFopAmount()) > 0) {
                return String.format(Messages.Fop_map_validate_message_notEnough, item.getPaymentType(), item.getFopAmount(), total);
            }
            totalFop = totalFop.add(item.getFopAmount());
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        int multipleMappingsCount = 0;
        for (PriceComponentWrapperVM mapping : this.priceComponents) {
            if (mapping.getFopUids().size() > 1) {
                ++multipleMappingsCount;
            }
            BigDecimal bigDecimal2 = var2_5.add(mapping.getPriceComponent().getAmount());
        }
        if (multipleMappingsCount > 1) {
            return Messages.Fop_map_validate_message_bindOnlyToOne;
        }
        if (var2_5.compareTo(totalFop) != 0) {
            return String.format(Messages.Fop_map_validate_message_totalNotEqualsToSum, var2_5, totalFop);
        }
        for (ExchangePaymentTypeWrapperVM item : this.exchangePaymentTypes) {
            if (item.getPaymentType() != null) continue;
            return String.format(Messages.Fop_map_validate_message_typeNotDefined, String.format("%s: %s", item.getFop().getPaymentType(), item.getFop().getFopAmount()));
        }
        return null;
    }

    private AirProductFopMapActionPanel createBody() {
        AirProductFopMapActionPanel body = new AirProductFopMapActionPanel(false);
        StringConverter<FOPWrapper> converterPaymentTypes = new StringConverter<FOPWrapper>(){

            public String toString(FOPWrapper fopWrapper) {
                if (fopWrapper == null) {
                    return "";
                }
                return String.format("%s: %s", fopWrapper.getPaymentType(), fopWrapper.getFopAmount());
            }

            public FOPWrapper fromString(String string) {
                return null;
            }
        };
        ((ComboBoxWidgetColumn)body.getPaymentTypesNode().getColumn("fop")).setConverter((StringConverter)converterPaymentTypes);
        StringConverter<CostItem> converterCostItem = new StringConverter<CostItem>(){

            public String toString(CostItem item) {
                if (item == null) {
                    return "";
                }
                if (item instanceof FareCostItem) {
                    return String.format(Messages.Fop_map_fare, item.getAmount());
                }
                if (item instanceof TaxCostItem) {
                    return String.format(Messages.Fop_map_tax, ((TaxCostItem)item).getTaxCode(), item.getAmount());
                }
                if (item instanceof PenaltyCostItem) {
                    return String.format(Messages.Fop_map_penalty, item.getAmount());
                }
                return "";
            }

            public CostItem fromString(String string) {
                return null;
            }
        };
        ((ComboBoxWidgetColumn)body.getCostItemNode().getColumn("priceComponent")).setConverter((StringConverter)converterCostItem);
        body.getPaymentTypesNode().setControlButtonsAvailability(ControlsPane.NONE);
        body.getCostItemNode().setControlButtonsAvailability(ControlsPane.NONE);
        return body;
    }

    private EntityReference<BookingFile> getRefBF(Tile<Node, BookingFileProductsFullPanel> tile) {
        RootEntityPane rep = RootEntityPane.lookup((Node)tile.getFullNode());
        if (rep == null || rep.getData() == null) {
            return null;
        }
        EntityContainer bfCont = rep.getData().getContainer();
        return bfCont.toReference();
    }

    private void loadData(Product product, EntityReference<BookingFile> bFRef) throws Exception {
        PriceComponentWrapperVM priceComponent;
        List fops = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getAirProductFops(ServiceInvocationContext.get(), bFRef, product.getUid());
        for (ProductFop fop2 : fops) {
            FOPWrapper fopWrapper = new FOPWrapper();
            fopWrapper.setFopUid(fop2.getUid());
            fopWrapper.setPaymentType(fop2.getType());
            fopWrapper.setFopAmount(fop2.getAmount() == null || fop2.getAmount().getValue() == null ? BigDecimal.ZERO : fop2.getAmount().getValue());
            fopWrapper.setExchangePaymentType(fop2.getExchangePaymentType());
            this.availableFops.add(fopWrapper);
        }
        ArrayList<PriceComponentWrapperVM> currentTotalFares = new ArrayList<PriceComponentWrapperVM>();
        ArrayList<PriceComponentWrapperVM> currentSegmentFares = new ArrayList<PriceComponentWrapperVM>();
        for (ProductFare fare : product.getFares()) {
            if (fare.getEquivalentFare() == null) continue;
            priceComponent = new PriceComponentWrapperVM();
            FareCostItem fareCostItem = new FareCostItem();
            fareCostItem.setUid(fare.getUid());
            fareCostItem.setAmount(fare.getEquivalentFare());
            fareCostItem.setMultipleUidsAllowed(true);
            priceComponent.setPriceComponent((CostItem)fareCostItem);
            for (ProductFop fop3 : fops) {
                if (!fop3.getFares().contains(fare)) continue;
                priceComponent.getFopUids().add(fop3.getUid());
            }
            if (fare.getSegmentTariff() != null) {
                currentSegmentFares.add(priceComponent);
                continue;
            }
            currentTotalFares.add(priceComponent);
        }
        List<PriceComponentWrapperVM> list = this.priceComponents = currentSegmentFares.isEmpty() ? currentTotalFares : currentSegmentFares;
        if (product.getPenalty() != null && product.getPenalty().compareTo(BigDecimal.ZERO) != 0) {
            PriceComponentWrapperVM priceComponent2 = new PriceComponentWrapperVM();
            PenaltyCostItem taxCostItem = new PenaltyCostItem();
            taxCostItem.setAmount(product.getPenalty());
            taxCostItem.setMultipleUidsAllowed(false);
            fops.stream().filter(fop -> fop.isHasPenaltyComponent()).map(fop -> fop.getUid()).findFirst().ifPresent(fopUid -> priceComponent2.getFopUids().add(fopUid));
            priceComponent2.setPriceComponent((CostItem)taxCostItem);
            this.priceComponents.add(priceComponent2);
        }
        for (Tax tax : product.getTaxes()) {
            priceComponent = new PriceComponentWrapperVM();
            TaxCostItem taxCostItem = new TaxCostItem();
            taxCostItem.setUid(tax.getUid());
            taxCostItem.setAmount(tax.getEquivalentAmount());
            taxCostItem.setMultipleUidsAllowed(false);
            taxCostItem.setTaxCode(tax.getCode());
            priceComponent.setPriceComponent((CostItem)taxCostItem);
            for (ProductFop fop3 : fops) {
                if (!fop3.getTaxes().contains(tax)) continue;
                priceComponent.getFopUids().add(fop3.getUid());
                break;
            }
            this.priceComponents.add(priceComponent);
        }
        for (FOPWrapper item : this.availableFops) {
            if (item.getPaymentType() != PaymentType.TICKET) continue;
            ExchangePaymentTypeWrapperVM mapping = new ExchangePaymentTypeWrapperVM();
            mapping.setFop(item);
            mapping.setPaymentType(item.getExchangePaymentType());
            this.exchangePaymentTypes.add(mapping);
        }
    }

    private void fillingBody(final AirProductFopMapActionPanel body) throws Exception {
        this.controllerPaymentTypes = new TableWidgetController<TableWidget<ExchangePaymentTypeWrapperVM>, ExchangePaymentTypeWrapperVM>(){

            public TableWidget<ExchangePaymentTypeWrapperVM> getView() {
                return body.getPaymentTypesNode();
            }
        };
        if (this.exchangePaymentTypes.isEmpty()) {
            body.getPaymentTypesCell().setHidden(true);
        } else {
            this.controllerPaymentTypes.readData(this.exchangePaymentTypes);
        }
        for (final FOPWrapper fopWrapper : this.availableFops) {
            TableWidgetColumn<PriceComponentWrapperVM, BooleanValueWidget> column = new TableWidgetColumn<PriceComponentWrapperVM, BooleanValueWidget>(){

                public BooleanValueWidget createNode() {
                    BooleanValueWidget widget = new BooleanValueWidget(true, false);
                    widget.getProperties().put((Object)AirProductFopMapActionDialog.FOP_WRAPPER_UID, (Object)fopWrapper.getFopUid());
                    widget.valueProperty().addListener((obs, oldVal, newVal) -> {
                        if (!((Boolean)widget.getProperties().get((Object)AirProductFopMapActionDialog.MULTIPLE_UIDS_ALLOWED)).booleanValue() && newVal.booleanValue()) {
                            String uidCostItem = (String)widget.getProperties().get((Object)AirProductFopMapActionDialog.COST_ITEM_UID);
                            PriceComponentWrapperVM element = body.getCostItemNode().getRowsData().stream().filter(costItem -> costItem.getPriceComponent().getUid().equals(uidCostItem)).findFirst().orElse(null);
                            ArrayList priceComponentWrappersTemp = new ArrayList(body.getCostItemNode().getRowsData());
                            int idx = priceComponentWrappersTemp.indexOf(element);
                            if (idx == -1) {
                                return;
                            }
                            for (int i = 1; i < body.getCostItemNode().getColumns().size(); ++i) {
                                if (widget.equals(((TableWidgetColumn)body.getCostItemNode().getColumns().get(i)).getWidget(idx))) continue;
                                ((BooleanValueWidget)((TableWidgetColumn)body.getCostItemNode().getColumns().get(i)).getWidget(idx)).setValue(false);
                            }
                        }
                    });
                    return widget;
                }

                public void readData(PriceComponentWrapperVM model, BooleanValueWidget node) {
                    node.getProperties().put((Object)AirProductFopMapActionDialog.MULTIPLE_UIDS_ALLOWED, (Object)model.getPriceComponent().isMultipleUidsAllowed());
                    node.getProperties().put((Object)AirProductFopMapActionDialog.COST_ITEM_UID, (Object)model.getPriceComponent().getUid());
                    if (model.getFopUids().contains(node.getProperties().get((Object)AirProductFopMapActionDialog.FOP_WRAPPER_UID))) {
                        node.setValue(true);
                    }
                }

                public void writeData(PriceComponentWrapperVM model, BooleanValueWidget node) {
                    if (node.getValue()) {
                        if (!model.getFopUids().contains(node.getProperties().get((Object)AirProductFopMapActionDialog.FOP_WRAPPER_UID))) {
                            model.getFopUids().add((String)node.getProperties().get((Object)AirProductFopMapActionDialog.FOP_WRAPPER_UID));
                        }
                    } else {
                        model.getFopUids().remove(node.getProperties().get((Object)AirProductFopMapActionDialog.FOP_WRAPPER_UID));
                    }
                }

                public void setReadonly(BooleanValueWidget widget, boolean readonly) {
                }

                public void setAclNotEditable(BooleanValueWidget node) {
                }

                public boolean isDataChanged(PriceComponentWrapperVM model, BooleanValueWidget node) {
                    return true;
                }
            };
            column.setCaption(String.format("%s: %s", fopWrapper.getPaymentType(), fopWrapper.getFopAmount()));
            List columnsTemp = body.getCostItemNode().getColumns();
            ArrayList<4> columnsWithNewColumn = new ArrayList<4>(columnsTemp);
            columnsWithNewColumn.add(column);
            body.getCostItemNode().setColumns(columnsWithNewColumn);
        }
        this.controllerCostItem = new TableWidgetController<TableWidget<PriceComponentWrapperVM>, PriceComponentWrapperVM>(){

            public TableWidget<PriceComponentWrapperVM> getView() {
                return body.getCostItemNode();
            }
        };
        this.controllerCostItem.readData(this.priceComponents);
    }
}

