/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.PlainGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerBonusCardVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerDocumentPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravellerContactsPanel;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.helpers.BookingFileTravelersTileHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProfileService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PersonTitle;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class BookingFileTravelersTileAction
implements TileAction<Node, BookingFileTravelersPanel> {
    public String getName(Tile<Node, BookingFileTravelersPanel> tile) {
        return Messages.Create_profile;
    }

    public String getDescription(Tile<Node, BookingFileTravelersPanel> tile) {
        return Messages.Create_profile_decr;
    }

    public double getWeight() {
        return 1.0;
    }

    public boolean isEnabled(Tile<Node, BookingFileTravelersPanel> tile) {
        BookingFileTravelerPanel selectedView = (BookingFileTravelerPanel)((PlainGroupsWidget)((BookingFileTravelersPanel)tile.getFullNode()).getContent()).getSelectedView();
        if (selectedView == null) {
            return false;
        }
        EntityBoxWidget personWidget = ((BookingFileTravelerGeneralPanel)selectedView.getGeneralParametersCard().getContent()).getProfileNode();
        return !personWidget.getViewState().isImmutable() && personWidget.getValue() == null;
    }

    public void execute(Control source, Tile<Node, BookingFileTravelersPanel> tile, boolean alt) {
        BookingFileTravelerPanel selectedView = (BookingFileTravelerPanel)((PlainGroupsWidget)((BookingFileTravelersPanel)tile.getFullNode()).getContent()).getSelectedView();
        if (selectedView == null) {
            return;
        }
        Notifications.get().submitTask(() -> {
            boolean hasFirstAndSecondName;
            List errors = ((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).checkDuplicatePassports(ServiceInvocationContext.get(), null, Collections.singletonList(new MiscUtil.Pair((Object)((BookingFileTravelerDocumentPanel)selectedView.getDocumentsCard().getContent()).getNumberNode().getValue(), (Object)DateUtils.asDate((LocalDate)((BookingFileTravelerDocumentPanel)selectedView.getDocumentsCard().getContent()).getBirthdayNode().getValue()))));
            if (!errors.isEmpty()) {
                Notifications.get().showMessages((Collection)errors);
                return;
            }
            EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)((BookingFileSpace)RootEntityPane.lookup((Node)selectedView).getEditor()).getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
            String name = ((BookingFileTravelerGeneralPanel)selectedView.getGeneralParametersCard().getContent()).getNameNode().getValue();
            boolean hasName = !TextUtil.isBlank((String)name);
            String firstName = ((BookingFileTravelerDocumentPanel)selectedView.getDocumentsCard().getContent()).getFirstNameNode().getValue();
            String secondName = ((BookingFileTravelerDocumentPanel)selectedView.getDocumentsCard().getContent()).getLastNameNode().getValue();
            boolean bl = hasFirstAndSecondName = !TextUtil.isBlank((String)firstName) && !TextUtil.isBlank((String)secondName);
            if (!hasName && !hasFirstAndSecondName) {
                Notifications.get().showMessages(new Message[]{MessageHelper.createErrorMessage((String)Messages.No_Name_specified, (Object[])new Object[0])});
                return;
            }
            if (client == null) {
                FxUtil.waitForFxThread(() -> {
                    EntityBoxWidget organizationEntityBoxWidget = new EntityBoxWidget(Organization.class, false);
                    organizationEntityBoxWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
                    Dialog dialog = new Dialog().setBody((Node)organizationEntityBoxWidget).setTitle(Messages.Client_not_set).setMessage(Messages.Choose_client).addButton(DialogButtonStyle.ACCEPT_CONTINUE, () -> {
                        RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)selectedView);
                        Notifications.get().submitTask(() -> {
                            EntityReference clientProfile = organizationEntityBoxWidget.getValue();
                            EntityContainer bfContainer = rootEntityPane.getData().getContainer();
                            ((BookingFile)bfContainer.getEntity()).setCustomerProfile(clientProfile);
                            bfContainer.getVersionInfo().setDataSource("set-bf-client");
                            ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), bfContainer, null, true);
                            rootEntityPane.reloadData();
                            this.createPerson((EntityReference<Organization>)clientProfile, source, selectedView, firstName, secondName, name);
                        }, rootEntityPane.getMutex());
                    }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)organizationEntityBoxWidget.valueProperty()));
                    dialog.show((Node)selectedView);
                });
            } else {
                this.createPerson((EntityReference<Organization>)client, source, selectedView, firstName, secondName, name);
            }
        }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading);
    }

    void createPerson(EntityReference<Organization> client, Control source, BookingFileTravelerPanel selectedView, String firstName, String secondName, String name) throws Exception {
        boolean result = ((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).checkPersonDublicate(ServiceInvocationContext.get(), client, firstName, secondName, name);
        FxUtil.waitForFxThread(() -> {
            if (result) {
                String nameInMessage = TextUtil.nonBlank((String)firstName) && TextUtil.nonBlank((String)secondName) ? firstName + " " + secondName : name;
                Dialog.confirm((Node)source, (String)L10n.replace((String)Messages.Create_profile_notification, (Object[])new Object[]{nameInMessage}), null, (String)Messages.Create, () -> this.createPerson(selectedView, client), () -> {});
            } else {
                this.createPerson(selectedView, client);
            }
        });
    }

    private void createPerson(BookingFileTravelerPanel selectedView, EntityReference<Organization> client) {
        Person person = new Person();
        this.fillingMainField(selectedView, person, client);
        this.fillingPassport(selectedView, person);
        this.fillingBonusCard(selectedView, person);
        this.fillCommunications(selectedView, person, client);
        BookingFileTravelersTileHelper helper = (BookingFileTravelersTileHelper)ReflectionUtil.createBySystemPropertyName((ClassLoader)RootEntityPane.class.getClassLoader(), (String)"client.fx.travelersTileActionHelper.class", null, () -> new BookingFileTravelersTileHelper(){

            @Override
            public void fillingContactFields(BookingFileTravelerPanel fullPanel, Person person) {
            }
        });
        helper.fillingContactFields(selectedView, person);
        EntityContainer personCont = EntityContainer.create((BaseEntity)person);
        Notifications.get().submitTask(() -> {
            personCont.getVersionInfo().setDataSource("fx-create-from-booking-file");
            ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), personCont, null, true);
            EntityEditorHelper.navigate((EntityReference)personCont.toReference(), (boolean)true);
            ((BookingFileTravelerGeneralPanel)selectedView.getGeneralParametersCard().getContent()).getProfileNode().setValue(personCont.toReference());
        }, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Data_loading);
    }

    private void fillingMainField(BookingFileTravelerPanel fullPanel, Person person, EntityReference<Organization> client) {
        person.getTypes().add(PersonType.PASSENGER);
        BookingFileTravelerGeneralPanel generalCard = (BookingFileTravelerGeneralPanel)fullPanel.getGeneralParametersCard().getContent();
        person.setTitle((PersonTitle)generalCard.getTitleNode().getValue());
        person.setGender((Gender)generalCard.getGenderNode().getValue());
        PersonEmployment employment = new PersonEmployment();
        employment.setOrganization(client);
        person.getEmployments().add(employment);
        BookingFileTravelerDocumentPanel documentPanel = (BookingFileTravelerDocumentPanel)fullPanel.getDocumentsCard().getContent();
        person.setBirthday(MiscUtil.toDate((LocalDate)documentPanel.getBirthdayNode().getValue()));
        this.setL10NString(person.getFirstName(), documentPanel.getFirstNameNode().getValue());
        this.setL10NString(person.getLastName(), documentPanel.getLastNameNode().getValue());
        this.setL10NString(person.getMiddleName(), documentPanel.getMiddleNameNode().getValue());
    }

    private void setL10NString(L10nString l10n, String name) {
        if (TextUtil.isBlank((String)name)) {
            return;
        }
        if (TextUtil.isCyrillic((String)name, (boolean)true)) {
            l10n.getValues().put(new Locale("ru"), name);
        } else {
            l10n.getValues().put(new Locale("en"), name);
        }
    }

    private void fillingBonusCard(BookingFileTravelerPanel fullPanel, Person person) {
        TableWidget bonusCard = (TableWidget)fullPanel.getBonusCardsCard().getContent();
        ArrayList<AirlineBonusCard> bonusCards = new ArrayList<AirlineBonusCard>();
        for (BookingFileTravelerBonusCardVM cardVM : bonusCard.getRowsData()) {
            AirlineBonusCard card = new AirlineBonusCard();
            card.setNumber(cardVM.getNumber());
            card.setAirline(cardVM.getAirline());
            card.setAirlineApplied(cardVM.getAirlineApplied());
            bonusCards.add(card);
        }
        person.getAirlineBonusCards().addAll(bonusCards);
    }

    private void fillingPassport(BookingFileTravelerPanel fullPanel, Person person) {
        BookingFileTravelerDocumentPanel documentsCard = (BookingFileTravelerDocumentPanel)fullPanel.getDocumentsCard().getContent();
        Passport passport = new Passport();
        passport.setBirthday(DateUtils.asDate((LocalDate)documentsCard.getBirthdayNode().getValue()));
        passport.setNumber(documentsCard.getNumberNode().getValue());
        passport.setFirstName(documentsCard.getFirstNameNode().getValue());
        passport.setMiddleName(documentsCard.getMiddleNameNode().getValue());
        passport.setLastName(documentsCard.getLastNameNode().getValue());
        passport.setType((PassportType)documentsCard.getDocumentTypeNode().getValue());
        passport.setGender((Gender)documentsCard.getGenderNode().getValue());
        passport.setCitizenship(documentsCard.getCitizenshipNode().getValue());
        passport.setExpired(DateUtils.asDate((LocalDate)documentsCard.getExpiredNode().getValue()));
        passport.setOriginCountry(documentsCard.getOriginCountryNode().getValue());
        passport.setIssued(DateUtils.asDate((LocalDate)documentsCard.getIssuedNode().getValue()));
        passport.setBirthPlace(documentsCard.getBirthPlaceNode().getValue());
        passport.setIssueOrganization(documentsCard.getIssueOrganizationNode().getValue());
        person.getPassports().add(passport);
    }

    private void fillCommunications(BookingFileTravelerPanel panel, Person person, EntityReference<Organization> organization) {
        PersonCommunication personCommunication;
        BookingFileTravellerContactsPanel contactsPanel = (BookingFileTravellerContactsPanel)panel.getCommunicationsCard().getContent();
        List communications = person.getCommunications();
        for (ContactPhonesTableVM vm : contactsPanel.getPhonesNode().getRowsData()) {
            personCommunication = new PersonCommunication();
            personCommunication.setType(vm.getType());
            personCommunication.setCountryCode(vm.getCountryCode());
            personCommunication.setCityCode(vm.getCityCode());
            personCommunication.setSense(vm.getPhoneNumber());
            personCommunication.setInternalNumber(vm.getInternalNumber());
            personCommunication.setRemarks(vm.getNotes());
            personCommunication.setOrganization(organization);
            communications.add(personCommunication);
        }
        for (ContactPhonesTableVM vm : contactsPanel.getEmailsNode().getRowsData()) {
            personCommunication = new PersonCommunication();
            personCommunication.setType(vm.getType());
            personCommunication.setSense(vm.getAddress());
            personCommunication.setRemarks(vm.getNotes());
            personCommunication.setOrganization(organization);
            communications.add(personCommunication);
        }
    }
}

