/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.HotelRefundPanelController;
import com.gridnine.xtrip.client.fx.model.booking.HotelRefundPanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductCreatePassiveSegmentsActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CancelBookingRequestHotelProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ChangePayerProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.PayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefundHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefundProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnpayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnrefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.model.booking.HotelRefundSettings;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;

public class HotelProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-hotel-product-actions-provider";
    }

    @Override
    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductHotelPanel;
    }

    @Override
    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<HotelProduct>(){

            @Override
            protected BaseProduct getPreviousProduct(HotelProduct product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<HotelProduct>(){

            @Override
            protected BaseProduct getNextProduct(HotelProduct product) {
                return product.getNextProduct();
            }
        }, new RecalculateFOPProductAction(), new PayProductAction<HotelProduct>(){

            @Override
            protected ProductStatus getStatus(HotelProduct product) {
                return product.getStatus();
            }
        }, new UnpayProductAction<HotelProduct>(){

            @Override
            protected ProductStatus getStatus(HotelProduct product) {
                return product.getStatus();
            }
        }, new RefusePaymentProductAction<HotelProduct>(){

            @Override
            protected ProductStatus getStatus(HotelProduct product) {
                return product.getStatus();
            }
        }, new UnrefusePaymentProductAction<HotelProduct>(){

            @Override
            protected ProductStatus getStatus(HotelProduct product) {
                return product.getStatus();
            }
        }, new CopyProductAction<HotelProduct>(){

            @Override
            protected boolean isEnabled(HotelProduct product) {
                return product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.BOOKING || ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus());
            }

            @Override
            protected void execute(ProductActionContext<HotelProduct> ctx) {
                CopyTask.showCopyDialog((EntityReference<BookingFile>)ctx.getRootPane().getData().getContainer().toReference(), ctx.getSelectedProduct().getUid(), ctx.getRootPane(), ctx.getRootPane().getMutex());
            }
        }, new RefundProductAction<HotelProduct>(){

            @Override
            protected boolean isEnabled(HotelProduct product) {
                boolean result;
                boolean bl = result = product != null && product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null;
                if (product.getReservation() == null || product.getReservation().getBookingFile() == null) {
                    return false;
                }
                result = result && product.getReservation().getBookingFile().getNumber() != null;
                return result;
            }

            @Override
            protected void execute(ProductActionContext<HotelProduct> ctx) {
                this.refund(ctx);
            }

            private void refund(ProductActionContext<HotelProduct> ctx) {
                boolean errors = ((BookingFileProductHotelPanel)ctx.getProductsWidget().getSelectedView()).getStatusesNode().getHasErrorsNode().getValue();
                new RefundOptionsDialog((Node)ctx.getRootPane(), ctx.getSelectedProduct(), errors, params -> Notifications.get().submitTask(() -> {
                    EntityReference ref = ctx.getRootPane().getData().getContainer().toReference();
                    String prodUid = ((HotelProduct)ctx.getSelectedProduct()).getUid();
                    BookingFileService.ProductRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).refundHotel(ServiceInvocationContext.get(), prodUid, ref, params);
                    Notifications.get().showMessages((Collection)result.getResultMessageList());
                    EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(ref, EntityModification.ModificationType.CHANGE)));
                }, ObservableMutex.lookup((Node)ctx.getProductsWidget()))).showDialog();
            }
        }, new ChangePayerProductAction(), new BaseProductCreatePassiveSegmentsActionsProvider(), new CancelBookingRequestHotelProductAction());
        return this.actions;
    }

    private static class RefundOptionsDialog {
        private final Node source;
        private final Consumer<HotelRefundSettings> callback;
        private final HotelProduct product;
        private final boolean errors;

        RefundOptionsDialog(Node source, HotelProduct product, boolean errors, Consumer<HotelRefundSettings> callback) {
            this.source = source;
            this.callback = callback;
            this.product = product;
            this.errors = errors;
        }

        void showDialog() {
            HotelRefundPanelController controller = new HotelRefundPanelController(false);
            HotelRefundPanelVM mainVM = new HotelRefundPanelVM();
            RefundHelper.toVM(this.product, mainVM, this.errors);
            controller.readData(mainVM);
            Dialog dialog = new Dialog().setTitle(Messages.Return_of_the_hotel_reservation).setBody((Node)controller.getView()).setAutoClose(false);
            dialog.setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Return, () -> {
                controller.writeData(mainVM);
                HotelRefundSettings params = new HotelRefundSettings();
                RefundHelper.fromVM(this.product, mainVM, params);
                this.callback.accept(params);
                dialog.close();
            }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).show(this.source);
        }
    }
}

