/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesTotalSum;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnvoidBaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.VoidProductAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;

public class MCOFeesProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-mcofees-product-actions-provider";
    }

    @Override
    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductMCOFeesPanel;
    }

    @Override
    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new BaseProductAction<MCOFees>(){

            @Override
            protected String getName() {
                return Messages.Recalculate;
            }

            @Override
            protected String getDescription() {
                return Messages.Recalculate;
            }

            @Override
            protected boolean isEnabled(MCOFees product) {
                return true;
            }

            @Override
            protected boolean isSaveRequired() {
                return false;
            }

            @Override
            protected void execute(ProductActionContext<MCOFees> ctx) {
                CompactNavigatorWidget productsWidget = ctx.getProductsWidget();
                BookingFileProductMCOFeesPanel view = (BookingFileProductMCOFeesPanel)productsWidget.getSelectedView();
                MoneyValueWidget totalValueNode = view.getGeneralNode().getOperationNode().getTotalValueNode();
                BigDecimal total = view.getGeneralNode().getSourceNode().getRowsData().stream().map(BookingFileProductMCOFeesTotalSum::getFare).filter(Objects::nonNull).map(Money::getValue).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                totalValueNode.setValue(MoneyHelper.buildMoney((BigDecimal)total, (String)Prefetched.getData().getEquivalentCurrency()));
            }

            public double getWeight() {
                return 0.0;
            }
        }, new VoidProductAction<MCOFees>(){

            @Override
            protected boolean isEnabled(MCOFees product) {
                return product != null && product.getStatus() == ProductStatus.SELL && product.getNextMCO() == null;
            }
        }, new UnvoidBaseProductAction<MCOFees>(){

            @Override
            protected boolean isEnabled(MCOFees product) {
                return product != null && product.getStatus() == ProductStatus.VOID;
            }
        });
        return this.actions;
    }
}

