/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductPayClientFOPDialog;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourceOperations;

public abstract class PayProductAction<P extends BaseProduct>
extends BaseProductAction<P> {
    public double getWeight() {
        return 90.0;
    }

    @Override
    protected String getName() {
        return Messages.Pay;
    }

    @Override
    protected String getDescription() {
        return Messages.Pay_service;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    @Override
    protected boolean isEnabled(P product) {
        return product != null && !ProductStatusHandler.getAllVoidStatuses().contains(this.getStatus(product));
    }

    @Override
    protected void execute(ProductActionContext<P> ctx) {
        Object selectedProduct = ctx.getSelectedProduct();
        EntityReference bfRef = ctx.getRootPane().getData().getContainer().toReference();
        Notifications.get().submitTask(() -> {
            ProductPayClientFOPDialog dialog = new ProductPayClientFOPDialog(selectedProduct.getUid(), (EntityReference<BookingFile>)bfRef, false);
            FxUtil.submitToFxThread(() -> ((ProductPayClientFOPDialog)dialog).showGlobal());
        }, Messages.Payment_process);
    }

    protected abstract ProductStatus getStatus(P var1);

    @Override
    protected AclQuery getACLQuery(EntityContainer<BookingFile> bookingFile, P product) {
        return AclQuery.AclQueryBuilder.get().entry(ModelAclResourceOperations.PAY.getId(), ModelRestrictionEntityResources.ENTITY_RESERVATION.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), new NestedEntityReference(bookingFile, product)).build();
    }
}

